/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.templates;

import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.templates.TemplateFile;
import eu.scorpionltd.uhc.manager.settings.templates.TemplateManager;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.utils.variable.list.VariableList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Template {
    private String name;
    private boolean isDefault;
    private String owner;
    private long creationDate;
    private TemplateFile file;
    private HashMap<String, Object> values;

    public Template(File f) {
        this(f.getName().replace(".yml", ""));
    }

    public Template(String name) {
        this.name = name;
        this.file = new TemplateFile(name);
        this.isDefault = this.file.getBoolean("options.isDefault");
        this.values = new HashMap();
        TemplateManager.getTemplates().add(this);
    }

    public String getName() {
        return this.name;
    }

    public void inverseDefault() {
        this.isDefault = !this.isDefault;
        this.file.setValue("options.isDefault", this.isDefault);
        this.file.saveFile();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public TemplateFile getFile() {
        return this.file;
    }

    public HashMap<String, Object> getValues() {
        return this.values;
    }

    public void loadSettings() {
        SettingsManager.getSettings().forEach(param -> {
            param.setValue(this.values.get(param.getVariable().getKey()));
            ServerUtil.sendSlotsChangeEvent(param);
        });
        if (Status.getCurrentStatus() != Status.LAUNCH) {
            this.loadScenarios();
            return;
        }
    }

    public void loadScenarios() {
        ScenarioManager.getScenarios().forEach(sc -> {
            if ((this.file.contains("variables.activated_scenarios." + sc.getName()) || this.values.containsKey("activated_scenarios." + sc.getName())) && !sc.isEnable()) {
                sc.inverseValue(null);
            }
        });
    }

    public void saveSettings() {
        SettingsManager.getSettings().forEach(param -> {
            if (param.getVariable() instanceof VariableList) {
                this.values.put(param.getVariable().getKey(), new ArrayList((List)param.getValue()));
            } else {
                this.values.put(param.getVariable().getKey(), param.getValue());
            }
        });
        ScenarioManager.getActivatedScenarios().forEach(sc -> this.values.put("activated_scenarios." + sc.getName(), true));
        this.saveFile();
    }

    public void saveFile() {
        this.values.forEach((key, value) -> this.file.setValue("variables." + key, value));
        this.file.saveFile();
    }

    public void removeTemplate() {
        this.file.getFile().delete();
        TemplateManager.getTemplates().remove(this);
    }
}

