/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.limits;

import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.limits.Limits;
import eu.scorpionltd.uhc.manager.settings.limits.LimitsFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LimitsManager {
    private static List<Limits> limits;
    private static LimitsFile limitsFile;

    public static void loadLimits() {
        limits = new ArrayList<Limits>();
        limitsFile = new LimitsFile();
        if (!limitsFile.getConfigFile().isConfigurationSection("limits")) {
            return;
        }
        limitsFile.getConfigFile().getConfigurationSection("limits").getKeys(false).forEach(s -> {
            Settings settings = SettingsManager.getSettings(s.replace("/", "."));
            if (settings != null) {
                new Limits(settings).loadAll();
            }
        });
    }

    public static void saveLimits() {
        Iterator<Limits> i = limits.iterator();
        while (i.hasNext()) {
            Limits limit = i.next();
            limit.saveAll();
            i.remove();
        }
        limitsFile.saveFile();
    }

    public static List<Limits> getLimits() {
        return limits;
    }

    public static int getLimitsLines() {
        return Math.max(1, (int)Math.ceil((double)limits.size() / 9.0));
    }

    public static LimitsFile getFile() {
        return limitsFile;
    }

    public static Limits getLimit(Settings settings) {
        return limits.stream().filter(limit -> limit.getSettings() == settings).findFirst().orElse(null);
    }
}

