/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.limits;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.limits.LimitsFile;
import eu.scorpionltd.uhc.manager.settings.limits.LimitsManager;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableBoolean;
import eu.scorpionltd.utils.variable.list.VariableDouble;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import eu.scorpionltd.utils.variable.list.VariableList;
import eu.scorpionltd.utils.variable.list.VariableMultiBoolean;
import eu.scorpionltd.utils.variable.list.VariableString;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Limits {
    private Settings settings;
    private Object limit;

    public Limits(Settings settings) {
        this.settings = settings;
        this.limit = settings.getValue();
        LimitsManager.getLimits().add(this);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void checkSettings(ScorpionPlayer player) {
        boolean isMax = this.isMaxValue();
        if (!isMax) {
            return;
        }
        this.settings.setValue(this.limit);
        MEnum.NUMBER_MAX.sendTo(player, new Object[0]);
    }

    public String getPath() {
        return "limits." + this.settings.getVariable().getKey().replace(".", "/");
    }

    public ItemStack getItemStack(ScorpionPlayer sp) {
        Item item = new Item(this.settings.getItem(sp));
        item.setAmount(1);
        item.setLore(new String[]{MEnum.LIMITS_ITEM_LORE_MODIFY.getText(sp, new Object[0]), MEnum.LIMITS_ITEM_LORE_REMOVE.getText(sp, new Object[0]), "", ChatColor.GRAY + "Limit: " + ChatColor.AQUA + this.limit});
        return item.toItemStackwithItemFlag(ItemFlag.values());
    }

    public ItemStack getAnvilItem(ScorpionPlayer sp) {
        return new Item(this.settings.getItem(sp).getType(), this.limit + "").toItemStack();
    }

    public boolean isGoodType(String object) {
        Variable var = this.settings.getVariable();
        if (var instanceof VariableBoolean) {
            return MathUtil.isBoolean(object);
        }
        if (var instanceof VariableInteger || var instanceof VariableMultiBoolean) {
            return MathUtil.isInt(object);
        }
        if (var instanceof VariableDouble) {
            return MathUtil.isDouble(object);
        }
        return true;
    }

    public boolean isMaxValue() {
        Variable var = this.settings.getVariable();
        if (var instanceof VariableBoolean) {
            boolean limit;
            boolean value = (Boolean)this.settings.getValue();
            return value != (limit = ((Boolean)this.getLimit()).booleanValue());
        }
        if (var instanceof VariableInteger || var instanceof VariableMultiBoolean) {
            int limit;
            int value = (Integer)this.settings.getValue();
            return value > (limit = ((Integer)this.getLimit()).intValue());
        }
        if (var instanceof VariableDouble) {
            double d;
            double value = (Double)this.settings.getValue();
            double limit = (Double)this.getLimit();
            return value > d;
        }
        return true;
    }

    public String getTypeLimit() {
        Variable var = this.settings.getVariable();
        if (var instanceof VariableBoolean) {
            return "Boolean";
        }
        if (var instanceof VariableInteger) {
            return "Integer";
        }
        if (var instanceof VariableDouble) {
            return "Double";
        }
        if (var instanceof VariableMultiBoolean) {
            return "MultiBoolean";
        }
        if (var instanceof VariableList) {
            return "Liste";
        }
        if (var instanceof VariableString) {
            return "String";
        }
        return "Unknown";
    }

    public Object getLimit() {
        Variable var = this.settings.getVariable();
        if (var instanceof VariableBoolean) {
            return (Boolean)this.limit;
        }
        if (var instanceof VariableInteger || var instanceof VariableMultiBoolean) {
            return (Integer)this.limit;
        }
        if (var instanceof VariableDouble) {
            return (Double)this.limit;
        }
        if (var instanceof VariableString) {
            return (String)this.limit;
        }
        return this.limit;
    }

    public void changeLimit(String object) {
        Variable var = this.settings.getVariable();
        if (var instanceof VariableBoolean) {
            this.limit = Boolean.parseBoolean(object);
        } else if (var instanceof VariableInteger || var instanceof VariableMultiBoolean) {
            this.limit = Integer.parseInt(object);
        } else if (var instanceof VariableDouble) {
            this.limit = Double.parseDouble(object);
        } else if (var instanceof VariableMultiBoolean) {
            this.limit = Integer.parseInt(object);
        } else if (var instanceof VariableString) {
            this.limit = object;
        }
    }

    public void removeLimit() {
        LimitsManager.getFile().getConfigFile().set(this.getPath(), null);
        LimitsManager.getLimits().remove(this);
    }

    public void loadAll() {
        LimitsFile file = LimitsManager.getFile();
        this.limit = file.getObject(this.getPath() + ".limit");
    }

    public void saveAll() {
        LimitsFile file = LimitsManager.getFile();
        file.setValue(this.getPath() + ".limit", this.limit);
    }
}

