/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.database.type;

import com.google.gson.JsonObject;
import eu.scorpionltd.database.Data;
import eu.scorpionltd.database.manager.RedisManager;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.config.Stat;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.Database;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import redis.clients.jedis.JedisCluster;

public class RedisSQL
extends Database {
    public RedisSQL() {
        super(DatabaseManager.DatabaseType.REDIS_SQL);
    }

    @Override
    public void onLoad() {
        if (ConfigFile.DATABASE_DYNAMIC_UPDATE.getBoolean()) {
            return;
        }
    }

    @Override
    public void onDisable() {
    }

    private JedisCluster getRedis(String source) {
        return RedisManager.getJedis((String)source);
    }

    @Override
    public PlayerInfos onLoadAccount(UUID uuid) {
        PlayerInfos info = UHCPlayerManager.getInfos(uuid);
        boolean upd = false;
        if (info == null) {
            info = new PlayerInfos(uuid);
            upd = true;
        }
        Data data = RedisManager.getData((UUID)uuid);
        JsonObject json = data.getData("uhc");
        json.addProperty("name", data.getUsername());
        json.addProperty("twitterName", data.getTwitter());
        json.addProperty("langue", data.getLang());
        for (Stat stat : info.getStats()) {
            Object value = stat.getGlobal();
            if (value instanceof Integer) {
                stat.setGlobal(json.get(stat.getName()).getAsInt());
                continue;
            }
            if (value instanceof Double) {
                stat.setGlobal(json.get(stat.getName()).getAsDouble());
                continue;
            }
            if (!(value instanceof String)) continue;
            stat.setGlobal(json.get(stat.getName()).getAsString());
        }
        if (upd) {
            UHCPlayerManager.getPlayerInfos().add(info);
        }
        return info;
    }

    @Override
    public PlayerInfos onReload(UUID uuid) {
        return null;
    }

    @Override
    public void onSaveAccount(UUID uuid, PlayerInfos playerInfos) {
        JsonObject json = new JsonObject();
        for (Stat s : playerInfos.getStats()) {
            if (s.getName() == "name" || s.getName() == "twitterName" || s.getName() == "langue") continue;
            json.addProperty(s.getName(), String.valueOf(s.getTotal()));
        }
        this.getRedis("JEDIS: SAVE UHC " + uuid).hset("supplayer:" + uuid, "uhc", json.toString());
    }

    @Override
    public void onSaveAllAccount() {
    }

    @Override
    public List<UUID> onAllUUID() {
        return new ArrayList<UUID>();
    }

    @Override
    public void onPlayerLogin(UUID uuid) {
        if (!ConfigFile.DATABASE_DYNAMIC_UPDATE.getBoolean()) {
            return;
        }
        this.onLoadAccount(uuid);
    }

    @Override
    public void onPlayerQuit(UUID uuid) {
        if (!ConfigFile.DATABASE_DYNAMIC_UPDATE.getBoolean()) {
            return;
        }
        this.onSaveAccount(uuid, UHCPlayerManager.getInfos(uuid));
    }
}

