/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.database.type;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.config.Stat;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.Database;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.bdd.Redis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RedisDB
extends Database {
    public static Redis redis;

    public RedisDB() {
        super(DatabaseManager.DatabaseType.REDIS);
    }

    @Override
    public void onLoad() {
        if (!MathUtil.isInt(ConfigFile.DATABASE_PORT.getRawString())) {
            MEnum.DATABASE_NO_PORT_NUMBER.sendAll(new Object[0]);
            return;
        }
        redis = new Redis(ConfigFile.DATABASE_HOST.getRawString(), ConfigFile.DATABASE_PASSWORD.getRawString(), Integer.parseInt(ConfigFile.DATABASE_PORT.getRawString()));
        redis.initPool();
    }

    @Override
    public void onDisable() {
        redis.closePool();
    }

    @Override
    public PlayerInfos onLoadAccount(UUID uuid) {
        PlayerInfos info = new PlayerInfos(uuid);
        Map request = redis.getJedis().hgetAll("account_uhc:" + uuid);
        for (Stat stat : info.getStats()) {
            Object value = stat.getGlobal();
            if (value instanceof Integer) {
                stat.setGlobal(Integer.valueOf((String)request.get(stat.getName())));
                continue;
            }
            if (value instanceof Double) {
                stat.setGlobal(Double.valueOf((String)request.get(stat.getName())));
                continue;
            }
            if (!(value instanceof String)) continue;
            stat.setGlobal(request.get(stat.getName()));
        }
        return info;
    }

    @Override
    public PlayerInfos onReload(UUID uuid) {
        PlayerInfos info = UHCPlayerManager.getInfos(uuid);
        Map request = redis.getJedis().hgetAll("account_uhc:" + uuid);
        if (!request.isEmpty() && request != null) {
            for (Stat stat : info.getStats()) {
                Object value = stat.getGlobal();
                if (value instanceof Integer) {
                    stat.setGlobal(Integer.valueOf((String)request.get(stat.getName())));
                    continue;
                }
                if (!(value instanceof Double)) continue;
                stat.setGlobal(Double.valueOf((String)request.get(stat.getName())));
            }
        }
        return info;
    }

    @Override
    public void onSaveAccount(UUID u, PlayerInfos playerInfos) {
        String uuid = u.toString();
        HashMap<String, String> request = new HashMap<String, String>();
        for (Stat s : playerInfos.getStats()) {
            request.put(s.getName(), String.valueOf(s.getTotal()));
        }
        redis.getJedis().hmset("account_uhc:" + uuid, request);
    }

    @Override
    public void onSaveAllAccount() {
        UHCPlayerManager.getPlayerInfos().forEach(infos -> this.onSaveAccount(infos.getUUID(), (PlayerInfos)infos));
    }

    @Override
    public List<UUID> onAllUUID() {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        redis.getJedis().getClusterNodes().values().stream().forEach(pool -> {
            for (String data : pool.getResource().keys("account_uhc:*")) {
                uuidList.add(UUID.fromString(data.replace("account_uhc:", "")));
            }
        });
        return uuidList;
    }

    @Override
    public void onPlayerLogin(UUID uuid) {
    }

    @Override
    public void onPlayerQuit(UUID uuid) {
    }
}

