/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.database.type;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.config.Stat;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.Database;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.bdd.MySql;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;

public class MySQL
extends Database {
    private MySql mySql;
    private String table = "uhc_accounts";

    public MySQL() {
        super(DatabaseManager.DatabaseType.SQL);
    }

    @Override
    public void onLoad() {
        if (!MathUtil.isInt(ConfigFile.DATABASE_PORT.getRawString())) {
            System.out.println("DATABASE - MYSQL: Pas de nombre pour le port");
            MEnum.DATABASE_NO_PORT_NUMBER.sendAll(new Object[0]);
            return;
        }
        this.mySql = new MySql(ConfigFile.DATABASE_HOST.getRawString(), ConfigFile.DATABASE_DATABASE.getRawString(), ConfigFile.DATABASE_USER.getRawString(), ConfigFile.DATABASE_PASSWORD.getRawString(), Integer.parseInt(ConfigFile.DATABASE_PORT.getRawString()));
        this.mySql.initPool();
        this.createTables();
    }

    @Override
    public void onDisable() {
    }

    @Override
    public PlayerInfos onLoadAccount(UUID uuid) {
        PlayerInfos info = new PlayerInfos(uuid);
        this.getMySql().query("SELECT * FROM `" + this.table + "` WHERE UUID='" + uuid.toString() + "'", rs -> {
            try {
                if (!rs.next()) {
                    this.getMySql().asyncUpdate("INSERT INTO `" + this.table + "`(`UUID`) VALUES ('" + uuid.toString() + "')");
                } else {
                    for (Stat stat : info.getStats()) {
                        String path = stat.getName();
                        Object value = stat.getGlobal();
                        if (value instanceof Integer) {
                            stat.setGlobal(rs.getInt(path));
                            continue;
                        }
                        if (value instanceof Double) {
                            stat.setGlobal(Double.parseDouble(rs.getString(path)));
                            continue;
                        }
                        if (!(value instanceof String)) continue;
                        stat.setGlobal(rs.getString(path));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        return info;
    }

    @Override
    public PlayerInfos onReload(UUID uuid) {
        PlayerInfos info = UHCPlayerManager.getInfos(uuid);
        if (!this.hasAccount(uuid)) {
            this.getMySql().update("INSERT INTO `" + this.table + "` (`UUID`) VALUES ('" + uuid.toString() + "')");
        }
        try {
            PreparedStatement rs = this.getMySql().getConnection().prepareStatement("SELECT `name`, `twitterName`, `langue`, `prewhitelist`, `wins`, `games`, `bestKillstreak`, `elo`, `bestLongshot`, `hostGames`, `hostTime`, `globalKills`, `globalDeaths`, `globalDiamonds`, `globalGolds`, `globalIrons`, `globalAnimals`, `globalMonsters`, `globalCaveTime` FROM `uhc_accounts` WHERE `UUID` = ?");
            rs.setString(1, uuid.toString());
            ResultSet rel = rs.executeQuery();
            while (rel.next()) {
                for (Stat stat : info.getStats()) {
                    String path = stat.getName();
                    Object value = stat.getGlobal();
                    if (value instanceof Integer) {
                        stat.setGlobal(rel.getInt(path));
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    stat.setGlobal(Double.parseDouble(rel.getString(path)));
                }
            }
            rs.close();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return info;
    }

    @Override
    public void onSaveAccount(UUID uuid, PlayerInfos playerInfos) {
        if (!this.hasAccount(uuid)) {
            this.getMySql().asyncUpdate("INSERT INTO `" + this.table + "` (`UUID`) VALUES ('" + uuid.toString() + "')");
        }
        StringBuilder name = new StringBuilder();
        for (Stat stat : playerInfos.getStats()) {
            name.append(",`" + stat.getName() + "` = '" + stat.getTotal() + "'");
        }
        this.mySql.update("UPDATE `" + this.table + "` SET " + name.toString().replaceFirst(",", "") + " WHERE UUID ='" + uuid.toString() + "'");
    }

    @Override
    public void onSaveAllAccount() {
        UHCPlayerManager.getPlayerInfos().forEach(infos -> this.onSaveAccount(infos.getUUID(), (PlayerInfos)infos));
    }

    @Override
    public List<UUID> onAllUUID() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        this.getMySql().query("SELECT `UUID` FROM " + this.table, r -> {
            try {
                while (r.next()) {
                    list.add(UUID.fromString(r.getString("UUID")));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
        return list;
    }

    public MySql getMySql() {
        return this.mySql;
    }

    private void createTables() {
        try (Connection c = this.getMySql().getConnection();
             PreparedStatement state2 = c.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.table + " (`#` INT NOT NULL AUTO_INCREMENT PRIMARY KEY, UUID VARCHAR(255) NULL , name VARCHAR(255) NULL DEFAULT 'Unknown' , twitterName VARCHAR(255) NULL DEFAULT 'Unknown' , langue VARCHAR(255) NULL DEFAULT 'FR' , prewhitelist INT(255) NULL DEFAULT '0' , wins INT(255) NULL DEFAULT '0' , games INT(255) NULL DEFAULT '0' , bestKillstreak INT(255) NULL DEFAULT '0' , elo INT(255) NULL DEFAULT '0' , bestLongshot VARCHAR(255) NULL DEFAULT '0' , hostGames INT(255) NULL DEFAULT '0' , hostTime INT(255) NULL DEFAULT '0' , globalKills INT(255) NULL DEFAULT '0' , globalDeaths INT(255) NULL DEFAULT '0' , globalDiamonds INT(255) NULL DEFAULT '0' , globalGolds INT(255) NULL DEFAULT '0' , globalIrons INT(255) NULL DEFAULT '0' , globalAnimals INT(255) NULL DEFAULT '0' , globalMonsters INT(255) NULL DEFAULT '0' , globalCaveTime INT(255) NULL DEFAULT '0')");){
            Bukkit.getConsoleSender().sendMessage("\u00a7aINFO: \u00a76MYSQL \u00a7rCreation des tables inexistantes en cours...");
            state2.executeUpdate();
        }
        catch (SQLException e) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cERROR: \u00a76MYSQL \u00a7rImpossible de creer les tables.");
            e.printStackTrace();
        }
    }

    public boolean hasAccount(UUID uuid) {
        try {
            PreparedStatement q = this.getMySql().getConnection().prepareStatement("SELECT UUID FROM " + this.table + " WHERE UUID = ?");
            q.setString(1, "" + uuid);
            ResultSet resultat = q.executeQuery();
            boolean hasAccount = resultat.next();
            q.close();
            return hasAccount;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void onPlayerLogin(UUID uuid) {
    }

    @Override
    public void onPlayerQuit(UUID uuid) {
    }
}

