/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.database.type;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.config.Stat;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.Database;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.uhc.util.world.MathUtil;
import eu.scorpionltd.utils.bdd.Mongo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bson.Document;

public class MongoDB
extends Database {
    private Mongo mongo;

    public MongoDB() {
        super(DatabaseManager.DatabaseType.MONGO);
    }

    @Override
    public void onLoad() {
        if (!MathUtil.isInt(ConfigFile.DATABASE_PORT.getRawString())) {
            MEnum.DATABASE_NO_PORT_NUMBER.sendAll(new Object[0]);
            return;
        }
        this.mongo = new Mongo(ConfigFile.DATABASE_HOST.getRawString(), ConfigFile.DATABASE_DATABASE.getRawString(), ConfigFile.DATABASE_COLLECTION.getRawString(), ConfigFile.DATABASE_USER.getRawString(), ConfigFile.DATABASE_PASSWORD.getRawString(), Integer.parseInt(ConfigFile.DATABASE_PORT.getRawString()));
        this.mongo.initPool();
    }

    @Override
    public void onDisable() {
        this.mongo.closePool();
    }

    @Override
    public PlayerInfos onLoadAccount(UUID uuid) {
        PlayerInfos info = new PlayerInfos(uuid);
        Document document = this.mongo.getDocumentByUniqueId(uuid.toString());
        if (document == null) {
            document = new Document("_id", (Object)uuid.toString());
            for (Stat stat : info.getStats()) {
                document.append(stat.getName(), stat.getTotal());
            }
            this.mongo.getCollection().insertOne((Object)document);
        }
        for (Stat stat : info.getStats()) {
            String path = stat.getName();
            Object value = stat.getGlobal();
            if (value instanceof Integer) {
                stat.setGlobal(document.getInteger((Object)path));
                continue;
            }
            if (value instanceof Double) {
                stat.setGlobal(document.getDouble((Object)path));
                continue;
            }
            if (!(value instanceof String)) continue;
            stat.setGlobal(document.getString((Object)path));
        }
        return info;
    }

    @Override
    public PlayerInfos onReload(UUID uuid) {
        Document document = this.mongo.getDocumentByUniqueId(uuid.toString());
        PlayerInfos info = UHCPlayerManager.getInfos(uuid);
        if (document == null) {
            document = new Document("_id", (Object)uuid.toString());
            for (Stat stat : info.getStats()) {
                document.append(stat.getName(), stat.getTotal());
            }
            this.mongo.getCollection().insertOne((Object)document);
        }
        for (Stat stat : info.getStats()) {
            String path = stat.getName();
            Object value = stat.getGlobal();
            if (value instanceof Integer) {
                stat.setGlobal(document.getInteger((Object)path));
                continue;
            }
            if (!(value instanceof Double)) continue;
            stat.setGlobal(document.getDouble((Object)path));
        }
        return info;
    }

    @Override
    public void onSaveAccount(UUID u, PlayerInfos playerInfos) {
        String uuid = u.toString();
        Document document = this.mongo.getDocumentByUniqueId(uuid);
        if (document == null) {
            document = new Document("_id", (Object)uuid.toString());
            for (Stat stat2 : playerInfos.getStats()) {
                document.append(stat2.getName(), stat2.getTotal());
            }
            this.mongo.getCollection().insertOne((Object)document);
            return;
        }
        playerInfos.getStats().forEach(stat -> this.mongo.sendRequest(stat.getTotal(), stat.getName(), uuid));
    }

    @Override
    public void onSaveAllAccount() {
        UHCPlayerManager.getPlayerInfos().forEach(infos -> this.onSaveAccount(infos.getUUID(), (PlayerInfos)infos));
    }

    @Override
    public List<UUID> onAllUUID() {
        ArrayList<UUID> uuid = new ArrayList<UUID>();
        this.mongo.getCollection().find().forEach(r -> uuid.add(UUID.fromString(r.getString((Object)"_id"))));
        return uuid;
    }

    @Override
    public void onPlayerLogin(UUID uuid) {
    }

    @Override
    public void onPlayerQuit(UUID uuid) {
    }
}

