/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.database.type;

import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerFile;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.config.Stat;
import eu.scorpionltd.uhc.manager.settings.database.Database;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Config
extends Database {
    public PlayerFile playerFile;

    public Config() {
        super(DatabaseManager.DatabaseType.CONFIG);
    }

    @Override
    public void onLoad() {
        this.playerFile = new PlayerFile();
    }

    @Override
    public void onDisable() {
    }

    @Override
    public PlayerInfos onLoadAccount(UUID uuid) {
        PlayerFile file = this.playerFile;
        PlayerInfos info = new PlayerInfos(uuid);
        for (Stat stat : info.getStats()) {
            String path = this.getPath(uuid) + "." + stat.getName();
            if (!file.contains(path)) continue;
            Object value = stat.getGlobal();
            if (value instanceof Integer) {
                stat.setGlobal(file.getInteger(path));
                continue;
            }
            if (value instanceof Double) {
                stat.setGlobal(file.getDouble(path));
                continue;
            }
            if (!(value instanceof String)) continue;
            stat.setGlobal(file.getString(path));
        }
        return info;
    }

    @Override
    public PlayerInfos onReload(UUID uuid) {
        PlayerFile file = this.playerFile;
        PlayerInfos info = UHCPlayerManager.getInfos(uuid);
        for (Stat stat : info.getStats()) {
            String path = this.getPath(uuid) + "." + stat.getName();
            if (!file.contains(path)) continue;
            Object value = stat.getGlobal();
            if (value instanceof Integer) {
                stat.setGlobal(file.getInteger(path));
                continue;
            }
            if (!(value instanceof Double)) continue;
            stat.setGlobal(file.getDouble(path));
        }
        return info;
    }

    @Override
    public void onSaveAccount(UUID uuid, PlayerInfos playerInfos) {
        PlayerFile file = this.getPlayerFile();
        boolean isServerHost = Values.SERVER_NUMBER_HOST.getBoolean();
        boolean isServerStat = Values.SERVER_STATS.getBoolean();
        for (Stat stat : playerInfos.getStats()) {
            String path = this.getPath(uuid) + "." + stat.getName();
            Object value = stat.getTotal();
            if (stat.isGlobal()) {
                file.setValue(path, value);
                continue;
            }
            if (isServerHost && stat.isServerHost()) {
                file.setValue(path, value);
                continue;
            }
            if (!isServerStat) continue;
            file.setValue(path, value);
        }
        this.playerFile.saveFile();
    }

    @Override
    public void onSaveAllAccount() {
        UHCPlayerManager.getPlayerInfos().forEach(infos -> this.onSaveAccount(infos.getUUID(), (PlayerInfos)infos));
    }

    @Override
    public List<UUID> onAllUUID() {
        ArrayList<UUID> uuid = new ArrayList<UUID>();
        if (this.playerFile.getConfigFile().isConfigurationSection("players")) {
            this.playerFile.getConfigFile().getConfigurationSection("players").getKeys(false).forEach(s -> uuid.add(UUID.fromString(s)));
        }
        return uuid;
    }

    public PlayerFile getPlayerFile() {
        return this.playerFile;
    }

    public String getPath(UUID uuid) {
        return "players." + uuid.toString();
    }

    @Override
    public void onPlayerLogin(UUID uuid) {
    }

    @Override
    public void onPlayerQuit(UUID uuid) {
    }
}

