/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.database;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.Database;
import eu.scorpionltd.uhc.manager.settings.database.type.Config;
import eu.scorpionltd.uhc.manager.settings.database.type.MongoDB;
import eu.scorpionltd.uhc.manager.settings.database.type.MySQL;
import eu.scorpionltd.uhc.manager.settings.database.type.RedisDB;
import eu.scorpionltd.uhc.manager.settings.database.type.RedisSQL;

public class DatabaseManager {
    public static Database database;

    public static void loadDatabase() {
        DatabaseType type = DatabaseManager.getDataBaseType();
        switch (type) {
            case REDIS_SQL: {
                database = new RedisSQL();
                break;
            }
            case SQL: {
                database = new MySQL();
                break;
            }
            case REDIS: {
                database = new RedisDB();
                break;
            }
            case MONGO: {
                database = new MongoDB();
                break;
            }
            case CONFIG: {
                database = new Config();
            }
            default: {
                database = new Config();
            }
        }
        database.onLoad();
        System.out.println("DATABASE: Chargement de la database " + type.name());
    }

    public static void disableDatabase() {
        database.onDisable();
    }

    public static void resetDatabase() {
        DatabaseManager.disableDatabase();
        DatabaseManager.loadDatabase();
        MEnum.DATABASE_RESET.sendAll(new Object[0]);
    }

    public static Database getDatabase() {
        return database;
    }

    public static DatabaseType getDataBaseType() {
        int value = ConfigFile.DATABASE_TYPE.getInteger();
        if (value == 1) {
            return DatabaseType.SQL;
        }
        if (value == 2) {
            return DatabaseType.REDIS;
        }
        if (value == 3) {
            return DatabaseType.MONGO;
        }
        if (value == 4) {
            return DatabaseType.REDIS_SQL;
        }
        return DatabaseType.CONFIG;
    }

    public static enum DatabaseType {
        CONFIG,
        SQL,
        REDIS,
        MONGO,
        REDIS_SQL;

    }
}

