/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.database;

import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import java.util.List;
import java.util.UUID;

public abstract class Database {
    private DatabaseManager.DatabaseType dataBaseType;

    public Database(DatabaseManager.DatabaseType dataBaseType) {
        this.dataBaseType = dataBaseType;
    }

    public DatabaseManager.DatabaseType getDatabase() {
        return this.dataBaseType;
    }

    public void onReloadAccount(UUID uuid) {
        PlayerInfos info = UHCPlayerManager.getInfos(uuid);
        this.onSaveAccount(uuid, info);
    }

    public abstract void onLoad();

    public abstract void onDisable();

    public abstract PlayerInfos onLoadAccount(UUID var1);

    public abstract PlayerInfos onReload(UUID var1);

    public abstract void onSaveAccount(UUID var1, PlayerInfos var2);

    public abstract void onSaveAllAccount();

    public abstract List<UUID> onAllUUID();

    public abstract void onPlayerLogin(UUID var1);

    public abstract void onPlayerQuit(UUID var1);
}

