/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.config;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.item.inventory.CreativeEvent;
import eu.scorpionltd.uhc.manager.integration.IntegrationManager;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigCategorie;
import eu.scorpionltd.uhc.scoreboard.TabManager;
import eu.scorpionltd.uhc.ui.admin.affichage.MenuChangeUI;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.chat.color.Colors;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.inventory.AnvilGUI;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.objets.MultiBoolean;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableBoolean;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import eu.scorpionltd.utils.variable.list.VariableItemStack;
import eu.scorpionltd.utils.variable.list.VariableList;
import eu.scorpionltd.utils.variable.list.VariableLocation;
import eu.scorpionltd.utils.variable.list.VariableMultiBoolean;
import eu.scorpionltd.utils.variable.list.VariableString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public enum ConfigFile {
    UI_COLOR_CONFIG(ConfigCategorie.UI, (Variable)new VariableInteger("config.ui.color_config", new ItemStack(Material.STAINED_GLASS), (int)Colors.BLACK.getBlock())),
    UI_COLOR_ADMIN(ConfigCategorie.UI, (Variable)new VariableInteger("config.ui.color_admin", new ItemStack(Material.STAINED_GLASS), (int)Colors.RED.getBlock())),
    UI_COLOR_HOST(ConfigCategorie.UI, (Variable)new VariableInteger("config.ui.color_host", new ItemStack(Material.STAINED_GLASS), (int)Colors.BLUE.getBlock())),
    UI_COLOR_SCENARIO(ConfigCategorie.UI, (Variable)new VariableInteger("config.ui.color_scenario", new ItemStack(Material.STAINED_GLASS), (int)Colors.GREEN.getBlock())),
    UI_COLOR_RULES(ConfigCategorie.UI, (Variable)new VariableInteger("config.ui.color_rules", new ItemStack(Material.STAINED_GLASS), (int)Colors.ORANGE.getBlock())),
    UI_COLOR_TEAM(ConfigCategorie.UI, (Variable)new VariableInteger("config.ui.color_team", new ItemStack(Material.STAINED_GLASS), (int)Colors.PURPLE.getBlock())),
    ITEMS_TEAMS(ConfigCategorie.ITEMS, (Variable)new VariableItemStack("config.lobby.item.teams", new ItemStack(Material.BANNER), new ItemStack(Material.BANNER))),
    ITEMS_CONFIG(ConfigCategorie.ITEMS, (Variable)new VariableItemStack("config.lobby.item.config", new ItemStack(Material.NETHER_STAR), new ItemStack(Material.NETHER_STAR))),
    ITEMS_PROFILE(ConfigCategorie.ITEMS, (Variable)new VariableItemStack("config.lobby.item.profile", new ItemStack(Material.EMERALD), new ItemStack(Material.EMERALD))),
    ITEMS_HUB(ConfigCategorie.ITEMS, (Variable)new VariableItemStack("config.lobby.item.hub", new ItemStack(Material.DARK_OAK_DOOR_ITEM), new ItemStack(Material.DARK_OAK_DOOR_ITEM))),
    ITEMS_CONFIRM_TO_LEAVE(ConfigCategorie.PLAYER, (Variable)new VariableBoolean("config.player.confirm_to_leave", new ItemStack(Material.DARK_OAK_DOOR_ITEM), true)),
    TEXT_COLOR_NUMBER(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.color_number", new ItemStack(Material.WATCH), "&f")),
    TEXT_COLOR_TEXT(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.color_text", new ItemStack(Material.SIGN), "&7")),
    TEXT_MAIN_PREFIX(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.main_prefix", new ItemStack(Material.COMPASS), "&7(&e&lSupUHC&7)&f")),
    TEXT_CONFIG_PREFIX(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.config_prefix", new ItemStack(Material.NETHER_STAR), "&7(&6&lConfig&7)&f")),
    TEXT_ADMIN_PREFIX(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.admin_prefix", new ItemStack(Material.REDSTONE_COMPARATOR), "&7(&c&lAdmin&7)&f")),
    TEXT_HOST_PREFIX(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.host_prefix", new ItemStack(Material.IRON_SWORD), "&7(&3&lHost&7)&f")),
    TEXT_TEAM_PREFIX(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.team_prefix", new ItemStack(Material.BANNER), "&7(&d&lTeam&7)&f")),
    TEXT_PLAYER_HOST(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.player_prefix", new ItemStack(Material.SKULL_ITEM, 1, 2), "&7(&bHOST&7) ")),
    TEXT_SPEC_HOST(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.spec_prefix", new ItemStack(Material.BANNER), "&7(&3SPEC&7) ")),
    TEXT_COHOST_HOST(ConfigCategorie.TEXT_COLORS, (Variable)new VariableString("config.text.cohost_prefix", new ItemStack(Material.SKULL_ITEM), "&7(&3CO-HOST&7) ")),
    COOLDOWN_CONFIRMATION(ConfigCategorie.COOLDOWN, (Variable)new VariableBoolean("config.cooldown.confirmation", new ItemStack(Material.FEATHER), true)),
    COOLDOWN_SOUND(ConfigCategorie.COOLDOWN, (Variable)new VariableBoolean("config.cooldown.sound", new ItemStack(Material.NOTE_BLOCK), false)),
    COOLDOWN_RULES_MENU(ConfigCategorie.COOLDOWN, (Variable)new VariableBoolean("config.cooldown.rules_menu", new ItemStack(Material.SIGN), true)),
    COOLDOWN_TIME(ConfigCategorie.COOLDOWN, (Variable)new VariableInteger("config.cooldown.time", new ItemStack(Material.WATCH), 10, 5, Integer.MAX_VALUE, 1, 1, 1)),
    COOLDOWN_START_ONLY_FULL(ConfigCategorie.COOLDOWN, (Variable)new VariableBoolean("config.cooldown.start_only_full", new ItemStack(Material.SKULL_ITEM, 1, 3), false)),
    INGAME_CUSTOM_DEATH_MESSAGE(ConfigCategorie.INGAME, (Variable)new VariableBoolean("config.ingame.custom_death_message", new ItemStack(Material.TNT), false)),
    INGAME_MOB_LIMIT(ConfigCategorie.INGAME, (Variable)new VariableBoolean("config.ingame.mob_limit", new ItemStack(Material.MOB_SPAWNER), false)),
    INGAME_MOB_NUMBER(ConfigCategorie.INGAME, (Variable)new VariableInteger("config.ingame.mob_number", new ItemStack(Material.MONSTER_EGGS), 1500, 100, Integer.MAX_VALUE, 100, 100, 100)),
    FINISH_TP_ENABLE(ConfigCategorie.FINISH, (Variable)new VariableBoolean("config.finish.tp_enable", new ItemStack(Material.GOLD_SWORD), false)),
    FINISH_TP_LOCATION(ConfigCategorie.FINISH, (Variable)new VariableLocation("config.finish.tp_location", new ItemStack(Material.EMERALD_BLOCK), new Location(LobbyUtil.getLobbyWorld(), 0.0, 102.0, 0.0))),
    FINISH_AUTO_STOP(ConfigCategorie.FINISH, (Variable)new VariableBoolean("config.finish.auto_stop", new ItemStack(Material.REDSTONE_BLOCK), false)),
    FINISH_STOP_COOLDOWN(ConfigCategorie.FINISH, (Variable)new VariableInteger("config.finish.stop_cooldown", new ItemStack(Material.WATCH), 120, 30, Integer.MAX_VALUE, 10, 10, 10)),
    BUNGEE_ENABLE(ConfigCategorie.BUNGEE, (Variable)new VariableBoolean("config.bungee.enable", new ItemStack(Material.COMMAND), false)),
    BUNGEE_KICK_PLAYER_SERV(ConfigCategorie.BUNGEE, (Variable)new VariableString("config.bungee.server_kick_name", new ItemStack(Material.DARK_OAK_DOOR_ITEM), "Lobby")),
    BUNGEE_ANNONCE_OPEN(ConfigCategorie.BUNGEE, (Variable)new VariableString("config.bungee.annonce_open", new ItemStack(Material.SLIME_BALL), "&cSupUHC is now open !")),
    PUBLIC_GAMES(ConfigCategorie.PLAYER, (Variable)new VariableInteger("config.player.public_games", new ItemStack(Material.PAPER), 0)),
    OP_CLEAR_IN_START(ConfigCategorie.PLAYER, (Variable)new VariableBoolean("config.player.op_clear", new ItemStack(Material.COMMAND), false)),
    COMBATLOG_TIME(ConfigCategorie.PLAYER, (Variable)new VariableInteger("config.player.pvplog_time", new ItemStack(Material.IRON_SWORD), 20, 1, Integer.MAX_VALUE, 1, 1, 1)),
    PRE_WHITELIST_PERCENT(ConfigCategorie.PLAYER, (Variable)new VariableInteger("config.player.pre_whitelist_percent", new ItemStack(Material.BOOK_AND_QUILL), 20, 10, 100, 10, 10, 10)),
    CHAT_LIFE_IN_TAB(ConfigCategorie.PLAYER, (Variable)new VariableBoolean("config.player.chat_life_in_tab", new ItemStack(Material.APPLE), true)),
    SPECS_POWER_NEAR(ConfigCategorie.SPECTATOR, (Variable)new VariableInteger("config.spectator.power_near", new ItemStack(Material.LEASH), 120, 50, 500, 5, 5, 5)),
    SPECS_REVIVE_AFTER_PVP(ConfigCategorie.SPECTATOR, (Variable)new VariableBoolean("config.spectator.revive_after_pvp", new ItemStack(Material.MOSSY_COBBLESTONE), true)),
    SPECS_BYPASS_REMOVE_BEFORE_PVP(ConfigCategorie.SPECTATOR, (Variable)new VariableBoolean("config.spectator.bypass_remove_before_pvp", new ItemStack(Material.COMMAND), false)),
    SPECS_REVIVE_REMOVE_DROPS(ConfigCategorie.SPECTATOR, (Variable)new VariableBoolean("config.spectator.revive_remove_drops", new ItemStack(Material.STICK), false)),
    ALERTS_DEATH_CAUSE(ConfigCategorie.ALERTS, (Variable)new VariableBoolean("config.alerts.death_cause", new ItemStack(Material.TNT), false)),
    ALERTS_GROUP_NUMBER(ConfigCategorie.ALERTS, (Variable)new VariableBoolean("config.alerts.group_number", new ItemStack(Material.LEATHER_CHESTPLATE), false)),
    ALERTS_OBSITRAP(ConfigCategorie.ALERTS, (Variable)new VariableBoolean("config.alerts.obsitrap", new ItemStack(Material.OBSIDIAN), false)),
    LOBBY_RESET(ConfigCategorie.LOBBY, (Variable)new VariableBoolean("config.lobby.resetmap", new ItemStack(Material.GOLD_AXE), true)),
    LOBBY_LOCATION(ConfigCategorie.LOBBY, (Variable)new VariableLocation("config.lobby.location", new ItemStack(Material.DIAMOND_BLOCK), new Location(LobbyUtil.getLobbyWorld(), 0.0, 102.0, 0.0))),
    LOBBY_TP_Y(ConfigCategorie.LOBBY, (Variable)new VariableInteger("config.lobby.tp_y", new ItemStack(Material.LADDER), 10, 0, 250, 5, 5, 5)),
    LOBBY_SPEED_AUTORULES(ConfigCategorie.LOBBY, (Variable)new VariableInteger("config.lobby.speed_autorules", new ItemStack(Material.SIGN), 40, 10, 100, 5, 5, 5)),
    ARENA_PREGEN_BEFORE_START(ConfigCategorie.ARENA, (Variable)new VariableBoolean("config.arena.pregen_before_start", new ItemStack(Material.MINECART), false)),
    ARENA_LIMIT_BORDER_MAX(ConfigCategorie.ARENA, (Variable)new VariableInteger("config.arena.limit_border_max", new ItemStack(Material.PRISMARINE), 0, 100, 5000, 100, 100, 100)),
    LANGUE_DEFAULT(ConfigCategorie.LANGUE, (Variable)new VariableString("config.langue.default_langue", new ItemStack(Material.NAME_TAG), "FR")),
    LANGUE_SWITCH(ConfigCategorie.LANGUE, (Variable)new VariableBoolean("config.langue.switch_langue", new ItemStack(Material.COMMAND), true)),
    DATABASE_TYPE(ConfigCategorie.DATABASE, (Variable)new VariableMultiBoolean("config.database.type", new ItemStack(Material.REDSTONE_LAMP_OFF), new MultiBoolean(0, 5))),
    DATABASE_HOST(ConfigCategorie.DATABASE, (Variable)new VariableString("config.database.host", new ItemStack(Material.SIGN), "")),
    DATABASE_PASSWORD(ConfigCategorie.DATABASE, (Variable)new VariableString("config.database.password", new ItemStack(Material.NAME_TAG), "")),
    DATABASE_PORT(ConfigCategorie.DATABASE, (Variable)new VariableString("config.database.port", new ItemStack(Material.WATER_BUCKET), "")),
    DATABASE_USER(ConfigCategorie.DATABASE, (Variable)new VariableString("config.database.user", new ItemStack(Material.SKULL_ITEM), "")),
    DATABASE_DATABASE(ConfigCategorie.DATABASE, (Variable)new VariableString("config.database.database", new ItemStack(Material.BOOKSHELF), "")),
    DATABASE_COLLECTION(ConfigCategorie.DATABASE, (Variable)new VariableString("config.database.collection", new ItemStack(Material.BOOK), "")),
    DATABASE_DYNAMIC_UPDATE(ConfigCategorie.DATABASE, (Variable)new VariableBoolean("config.database.dynamic_update", new ItemStack(Material.REDSTONE), false)),
    TWITTER_ENABLE(ConfigCategorie.TWITTER, (Variable)new VariableBoolean("config.twitter.enable", new ItemStack(Material.WOOD_BUTTON), false)),
    TWITTER_CONSUMER_KEY(ConfigCategorie.TWITTER, (Variable)new VariableString("config.twitter.consumer_key", new ItemStack(Material.STONE), "")),
    TWITTER_CONSUMER_SECRET(ConfigCategorie.TWITTER, (Variable)new VariableString("config.twitter.consumer_secret", new ItemStack(Material.STONE, 1, 1), "")),
    TWITTER_TOKEN_KEY(ConfigCategorie.TWITTER, (Variable)new VariableString("config.twitter.token_key", new ItemStack(Material.STONE, 1, 2), "")),
    TWITTER_TOKEN_SECRET(ConfigCategorie.TWITTER, (Variable)new VariableString("config.twitter.token_secret", new ItemStack(Material.STONE, 1, 3), "")),
    TWITTER_PUBLISH_MESSAGE(ConfigCategorie.TWITTER, (Variable)new VariableString("config.twitter.publish_message", new ItemStack(Material.BOOK_AND_QUILL), "")),
    TWITTER_FINISH_MESSAGE(ConfigCategorie.TWITTER, (Variable)new VariableString("config.twitter.finish_message", new ItemStack(Material.STONE_SWORD), "")),
    TWITTER_EXTERNAL_VALUE(ConfigCategorie.TWITTER, (Variable)new VariableBoolean("config.twitter.external_value", new ItemStack(Material.SIGN), false)),
    TWITTER_AUTO_FINISH(ConfigCategorie.TWITTER, (Variable)new VariableBoolean("config.twitter.auto_finish", new ItemStack(Material.CHEST), true)),
    DISCORD_ENABLE(ConfigCategorie.DISCORD, (Variable)new VariableBoolean("config.discord.enable", new ItemStack(Material.STONE_BUTTON), false)),
    DISCORD_WEBHOOK(ConfigCategorie.DISCORD, (Variable)new VariableString("config.discord.webhook", new ItemStack(Material.STONE), "")),
    DISCORD_USERNAME(ConfigCategorie.DISCORD, (Variable)new VariableString("config.discord.username", new ItemStack(Material.SKULL_ITEM), "SupUHC")),
    DISCORD_AVATAR(ConfigCategorie.DISCORD, (Variable)new VariableString("config.discord.avatar", new ItemStack(Material.SKULL_ITEM), "")),
    DISCORD_PUBLISH_MESSAGE(ConfigCategorie.DISCORD, (Variable)new VariableString("config.discord.publish_message", new ItemStack(Material.BOOK_AND_QUILL), "")),
    DISCORD_FINISH_MESSAGE(ConfigCategorie.DISCORD, (Variable)new VariableString("config.discord.finish_message", new ItemStack(Material.STONE_SWORD), "")),
    DISCORD_EXTERNAL_VALUE(ConfigCategorie.DISCORD, (Variable)new VariableBoolean("config.discord.external_value", new ItemStack(Material.SIGN), false)),
    DISCORD_AUTO_FINISH(ConfigCategorie.DISCORD, (Variable)new VariableBoolean("config.discord.auto_finish", new ItemStack(Material.CHEST), true)),
    ELO_DEFAULT(ConfigCategorie.ELO, (Variable)new VariableInteger("config.elo.default_elo", new ItemStack(Material.ARMOR_STAND), 1000)),
    TAB_ENABLE(ConfigCategorie.TAB, (Variable)new VariableBoolean("config.tab.enable", new ItemStack(Material.SIGN), false)),
    TAB_UPDATE(ConfigCategorie.TAB, (Variable)new VariableBoolean("config.tab.update", new ItemStack(Material.COMMAND), false)),
    TAB_DEAD_PREFIX(ConfigCategorie.TAB, (Variable)new VariableString("config.tab.dead_prefix", new ItemStack(Material.SKULL_ITEM), "&0&m")),
    TAB_HEADER(ConfigCategorie.TAB, (Variable)new VariableString("config.tab.header", new ItemStack(Material.WOOD_STAIRS), "&bSupUHC &7- &3Plugin UHC Host Server<retour>@&bSupDevPro &7by &3Rremis<retour>")),
    TAB_FOOTER(ConfigCategorie.TAB, (Variable)new VariableString("config.tab.footer", new ItemStack(Material.WOOD_STEP), "<retour>&ePing&7: &b<ping>ms &7| &eTPS&7: &b<tps><retour>&eQC&7: &b<utc:-4> &7| &eUTC&7: &b<utc> &7| &eFR&7: &b<utc:2> &7")),
    ACTIONBAR_ENABLE(ConfigCategorie.ACTION_BAR, (Variable)new VariableBoolean("config.action_bar.enable", new ItemStack(Material.SIGN), false)),
    ACTIONBAR_BEFORE_PVP(ConfigCategorie.ACTION_BAR, (Variable)new VariableString("config.action_bar.before_pvp", new ItemStack(Material.DIAMOND_SWORD), "&7PvP: &b<timers.pvp>")),
    ACTIONBAR_BEFORE_MEETUP(ConfigCategorie.ACTION_BAR, (Variable)new VariableString("config.action_bar.before_meetup", new ItemStack(Material.GLASS), "&7Meetup: &b<timers.meetup>")),
    ACTIONBAR_AFTER_MEETUP(ConfigCategorie.ACTION_BAR, (Variable)new VariableString("config.action_bar.after_meetup", new ItemStack(Material.ARMOR_STAND), "&7Border : &d<border>")),
    SB_PVE(ConfigCategorie.KILLS_SB, (Variable)new VariableBoolean("config.scoreboard.enable_pve", new ItemStack(Material.MONSTER_EGG), true)),
    SB_PVE_TEXT(ConfigCategorie.KILLS_SB, (Variable)new VariableString("config.scoreboard.pve_text", new ItemStack(Material.SIGN), "&9P&7v&4E")),
    SB_TK_ALIVE(ConfigCategorie.KILLS_SB, (Variable)new VariableString("config.scoreboard.tk_alive", new ItemStack(Material.BLAZE_ROD), "&e")),
    SB_TK_DEATH(ConfigCategorie.KILLS_SB, (Variable)new VariableString("config.scoreboard.tk_death", new ItemStack(Material.STICK), "&8")),
    SB_PLAYERS(ConfigCategorie.KILLS_SB, (Variable)new VariableBoolean("config.scoreboard.enable_players", new ItemStack(Material.SKULL_ITEM, 1, 3), false)),
    SB_PLAYERS_TEXT(ConfigCategorie.KILLS_SB, (Variable)new VariableString("config.scoreboard.players_text", new ItemStack(Material.IRON_SWORD), "&b&lPlayers")),
    SB_LOBBY_TITLE(ConfigCategorie.LOBBY_SB, (Variable)new VariableString("config.scoreboard.lobby_title", new ItemStack(Material.SIGN), "&6&lSupUHC &5#&d<number_games>")),
    SB_LOBBY_LINES(ConfigCategorie.LOBBY_SB, (Variable)new VariableList("config.scoreboard.lobby_lines", new ItemStack(Material.BOOK), Arrays.asList("&7Host: &c<host_name>", "&7Players: &a<number_players>&7/&2<max_players>", "&8&m------------", "&7Teamsize: &f<teamsize>", "&7Scenarios: ", "&8 - &e<scenario_list>", "&8&m------------", "&b@SupDevPro"))),
    SB_TIMER_COLOR(ConfigCategorie.GAME_SB, (Variable)new VariableString("config.scoreboard.timer_color", new ItemStack(Material.WATCH), "&b")),
    SB_GAME_TITLE(ConfigCategorie.GAME_SB, (Variable)new VariableString("config.scoreboard.ingame_title", new ItemStack(Material.SIGN), "&6&lSupUHC &5#&d<number_games>")),
    SB_GAME_LINES(ConfigCategorie.GAME_SB, (Variable)new VariableList("config.scoreboard.ingame_lines", new ItemStack(Material.BOOK), Arrays.asList("&7Host: &c<host_name>", "&7Players: &a<number_players>", "&8&m------------", "&7Timer: &b<game_timer>", "&7PvP: <timers.pvp>", "&7Meetup: <timers.meetup>", "&8&m------------", "&7Kills: &b<kills>", "&7Team Kills: &b<team_kills>", "&8&m------------", "&7Border: &d<border>", "&7Episode: &5<episode>", "&8&m------------", "&b@SupDevPro")));

    private ConfigCategorie cat;
    private Variable var;
    private UHCMessage name;

    private ConfigFile(ConfigCategorie cat, Variable var) {
        this.cat = cat;
        this.var = var;
    }

    public ConfigCategorie getCategorie() {
        return this.cat;
    }

    public Variable getVariable() {
        return this.var;
    }

    public String getPath() {
        return this.var.getKey();
    }

    public UHCMessage getName() {
        return this.name;
    }

    public String getNameText(ScorpionPlayer player) {
        return this.name.getText(player, new Object[0]);
    }

    public void setValue(Object object) {
        if (this.var instanceof VariableBoolean) {
            boolean value = (Boolean)object;
            ((VariableBoolean)this.var).setValue(value);
        } else if (this.var instanceof VariableMultiBoolean) {
            int value = (Integer)object;
            ((VariableMultiBoolean)this.var).changeValue(value);
        } else if (this.var instanceof VariableInteger) {
            int value = (Integer)object;
            ((VariableInteger)this.var).setValue(value);
        } else if (this.var instanceof VariableString) {
            String value = (String)object;
            ((VariableString)this.var).setValue(value);
        } else if (this.var instanceof VariableList) {
            List value = (List)object;
            ((VariableList)this.var).setList(value);
        } else if (this.var instanceof VariableLocation) {
            Location value = (Location)object;
            ((VariableLocation)this.var).setValue(value);
        } else if (this.var instanceof VariableItemStack) {
            ItemStack value = (ItemStack)object;
            ((VariableItemStack)this.var).changeStack(value);
        }
        ConfigFile.save(UHC.getInstance(), this);
        UHC.getInstance().saveConfig();
    }

    public Object getValue() {
        if (this.var instanceof VariableBoolean) {
            return ((VariableBoolean)this.var).isValue();
        }
        if (this.var instanceof VariableMultiBoolean) {
            return ((VariableMultiBoolean)this.var).getValue();
        }
        if (this.var instanceof VariableInteger) {
            return ((VariableInteger)this.var).getValue();
        }
        if (this.var instanceof VariableString) {
            return ((VariableString)this.var).getValue().replace("&", "\u00a7");
        }
        if (this.var instanceof VariableList) {
            return ((VariableList)this.var).getList();
        }
        if (this.var instanceof VariableLocation) {
            return ((VariableLocation)this.var).getValue();
        }
        if (this.var instanceof VariableItemStack) {
            return ((VariableItemStack)this.var).getStack();
        }
        return null;
    }

    public String getTextValue(Langue langue) {
        if (this.var instanceof VariableBoolean) {
            return (Boolean)this.getValue() != false ? MEnum.VALUE_ON.getText(langue, new Object[0]) : MEnum.VALUE_OFF.getText(langue, new Object[0]);
        }
        if (this.var instanceof VariableMultiBoolean) {
            return UHCMessage.get(this.getPath() + "." + this.getValue()).getText(langue, new Object[0]);
        }
        if (this.var instanceof VariableInteger) {
            return ChatColor.AQUA + "" + this.getValue() + " " + ChatColor.GRAY + UHCMessage.get(this.getPath() + ".type").getText(langue, new Object[0]);
        }
        if (this.var instanceof VariableLocation) {
            Location loc = (Location)this.getValue();
            return ChatColor.AQUA + "" + loc.getBlockX() + ChatColor.GRAY + " X / " + ChatColor.AQUA + "" + loc.getBlockY() + ChatColor.GRAY + " Y / " + ChatColor.AQUA + "" + loc.getBlockZ() + ChatColor.GRAY + " Z";
        }
        return this.getValue().toString().replace("&", "\u00a7");
    }

    public String getTextValue(ScorpionPlayer sp) {
        return this.getTextValue(UHCPlayerManager.getPlayer(sp).getLangue());
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public int getInteger() {
        return (Integer)this.getValue();
    }

    public String getRawString() {
        return ((String)this.getValue()).replace('\u00a7', '&');
    }

    public String getString() {
        return (String)this.getValue();
    }

    public Location getLocation() {
        return (Location)this.getValue();
    }

    public ItemStack getItemStack() {
        return ((ItemStack)this.getValue()).clone();
    }

    public boolean isSameMaterialData(Material material, short data) {
        ItemStack stack = this.getItemStack();
        return stack.getType() == material && stack.getDurability() == data;
    }

    public boolean isSameMaterial(Material material) {
        ItemStack stack = this.getItemStack();
        return stack.getType() == material;
    }

    public short getColor() {
        return Colors.getColorWithBlock((short)this.getInteger()).getBlock();
    }

    public List<String> getListString() {
        return (List)this.getValue();
    }

    public void setupMessages() {
        if (this.var instanceof VariableMultiBoolean) {
            VariableMultiBoolean vmb = (VariableMultiBoolean)this.var;
            for (int i = 0; i < vmb.getNumbers(); ++i) {
                new UHCMessage(this.getPath() + "." + i);
            }
            this.name = new UHCMessage(this.getPath() + ".name");
        } else if (this.var instanceof VariableInteger) {
            new UHCMessage(this.getPath() + ".type");
            this.name = new UHCMessage(this.getPath() + ".name");
        } else {
            this.name = new UHCMessage(this.getPath());
        }
    }

    public void addSimpleItem(CustomInventory inv, int categorie, int slot) {
        Item item = new Item(this.var.getItemStack().clone());
        item.setName(this.getNameText(inv.getScorpionPlayer()) + this.getValue());
        if (item.getMaterial() == Material.STAINED_GLASS) {
            item.setDurabilite((short)this.getInteger());
        }
        inv.addItem(new StaticItem(categorie, slot, item.toItemStackwithItemFlag(ItemFlag.values())));
    }

    public static void reloadAll(JavaPlugin plugin) {
        plugin.reloadConfig();
        plugin.saveConfig();
        ConfigFile.setDefault(plugin);
        MEnum.RESET_CONFIG.sendAll(new Object[0]);
    }

    public static void saveAll(JavaPlugin plugin) {
        for (ConfigFile config : ConfigFile.values()) {
            ConfigFile.save(plugin, config);
        }
        plugin.saveConfig();
    }

    public static void save(JavaPlugin plugin, ConfigFile config) {
        Variable var = config.getVariable();
        if (var instanceof VariableBoolean) {
            VariableBoolean v = (VariableBoolean)var;
            plugin.getConfig().set(config.getPath(), (Object)v.isValue());
        } else if (var instanceof VariableInteger) {
            VariableInteger v = (VariableInteger)var;
            plugin.getConfig().set(config.getPath(), (Object)v.getValue());
        } else if (var instanceof VariableMultiBoolean) {
            VariableMultiBoolean v = (VariableMultiBoolean)var;
            plugin.getConfig().set(config.getPath(), (Object)v.getValue());
        } else if (var instanceof VariableString) {
            VariableString v = (VariableString)var;
            plugin.getConfig().set(config.getPath(), (Object)v.getValue().replace('\u00a7', '&'));
        } else if (var instanceof VariableList) {
            VariableList v = (VariableList)var;
            plugin.getConfig().set(config.getPath(), (Object)v.getList());
        } else if (var instanceof VariableLocation) {
            VariableLocation v = (VariableLocation)var;
            plugin.getConfig().set(config.getPath(), (Object)v.getValue());
        } else if (var instanceof VariableItemStack) {
            VariableItemStack v = (VariableItemStack)var;
            plugin.getConfig().set(config.getPath(), (Object)v.getStack());
        }
    }

    public static void setDefault(JavaPlugin plugin) {
        for (ConfigFile config : ConfigFile.values()) {
            if (plugin.getConfig().get(config.getPath()) == null) {
                ConfigFile.save(plugin, config);
                continue;
            }
            if (config.getVariable() instanceof VariableItemStack) {
                config.setValue(plugin.getConfig().getItemStack(config.getPath()));
                continue;
            }
            config.setValue(plugin.getConfig().get(config.getPath()));
        }
        plugin.saveConfig();
    }

    public static List<ConfigFile> getConfigs(ConfigCategorie cat) {
        ArrayList<ConfigFile> list = new ArrayList<ConfigFile>();
        for (ConfigFile config : ConfigFile.values()) {
            if (!config.getCategorie().equals((Object)cat)) continue;
            list.add(config);
        }
        return list;
    }

    public ItemStack getItem(ScorpionPlayer sp) {
        Item item = this.var instanceof VariableItemStack ? new Item(this.getItemStack()) : new Item(this.var.getItemStack().clone());
        item.setName(this.getNameText(sp));
        if (this.var instanceof VariableBoolean) {
            item.setAmount((Boolean)this.getValue() != false ? 1 : 0);
            item.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(sp, new Object[0]), " ", MEnum.STATE.getText(sp, new Object[0]) + this.getTextValue(sp)});
        } else if (this.var instanceof VariableMultiBoolean) {
            item.setAmount(((Integer)this.getValue()).intValue());
            item.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(sp, new Object[0]), " ", MEnum.STATE.getText(sp, new Object[0]) + this.getTextValue(sp)});
        } else if (this.var instanceof VariableInteger) {
            if (item.getMaterial() == Material.STAINED_GLASS) {
                item.setDurabilite((short)this.getInteger());
                item.setLore(new String[]{MEnum.CHANGE_COLOR.getText(sp, new Object[0]), "", MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getValue()});
            } else {
                VariableInteger vi = (VariableInteger)this.var;
                String type = UHCMessage.get(this.getPath() + ".type").getText(sp, new Object[0]);
                item.setLore(new String[]{MEnum.LEFT_CLICK.getText(sp, new Object[0]) + MEnum.ADD.getText(sp, new Object[0]) + vi.getGreen() + " " + type, MEnum.RIGHT_CLICK.getText(sp, new Object[0]) + MEnum.REMOVE.getText(sp, new Object[0]) + vi.getGreen() + " " + type, " ", MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getTextValue(sp)});
            }
        } else if (this.var instanceof VariableString) {
            item.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(sp, new Object[0]), " ", MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getString().replace('\u00a7', '&')});
        } else if (this.var instanceof VariableLocation) {
            item.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(sp, new Object[0]), " ", MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getTextValue(sp)});
        } else if (this.var instanceof VariableItemStack) {
            item.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(sp, new Object[0])});
        }
        return item.toItemStackwithItemFlag(ItemFlag.values());
    }

    public void sendMessage(ScorpionPlayer sp) {
        sp.getPlayer().sendMessage(ChatUtil.getAdminPrefix() + (ChatUtil.getAdminPrefix().endsWith(" ") ? "" : " ") + ChatColor.YELLOW + this.getNameText(sp) + " " + ChatUtil.getArrow() + this.getTextValue(sp) + " " + this.cat.getCategorieName());
    }

    public void addStaticItem(CustomInventory inv, int categorie, int slot) {
        inv.addItem(new StaticItem(categorie, slot, this.getItem(inv.getScorpionPlayer())));
    }

    public void addActionItem(final CustomInventory inv, int categorie, int slot) {
        final ConfigFile configFile = this;
        inv.addActionItem(new ActionItem(categorie, slot, this.getItem(inv.getScorpionPlayer())){

            public void onClick(InventoryClickEvent e) {
                if (ConfigFile.this.var instanceof VariableBoolean) {
                    ((VariableBoolean)ConfigFile.this.var).inverseValue();
                    if (ConfigFile.this.getPath() == TAB_ENABLE.getPath() || ConfigFile.this.getPath() == TAB_UPDATE.getPath()) {
                        TabManager.setupTab();
                    }
                    if (ConfigFile.this.getPath() == BUNGEE_ENABLE.getPath()) {
                        ServerUtil.setupBungeeCordChannel((Plugin)UHC.getInstance());
                    }
                    configFile.setValue(((VariableBoolean)ConfigFile.this.var).isValue());
                }
                if (ConfigFile.this.var instanceof VariableInteger) {
                    if (ConfigFile.this.var.getItemStack().getType() == Material.STAINED_GLASS) {
                        new MenuChangeUI(inv.getScorpionPlayer(), configFile).openMenu();
                        return;
                    }
                    if (e.isLeftClick()) {
                        ((VariableInteger)ConfigFile.this.var).addGreen();
                    } else {
                        ((VariableInteger)ConfigFile.this.var).removeGreen();
                    }
                    configFile.setValue(((VariableInteger)ConfigFile.this.var).getValue());
                }
                if (ConfigFile.this.var instanceof VariableMultiBoolean) {
                    configFile.setValue(((VariableMultiBoolean)ConfigFile.this.var).getNext());
                }
                if (ConfigFile.this.var instanceof VariableLocation) {
                    configFile.setValue(inv.getScorpionPlayer().getPlayer().getLocation());
                }
                if (ConfigFile.this.var instanceof VariableString) {
                    AnvilGUI gui = new AnvilGUI(inv.getScorpionPlayer().getPlayer(), new AnvilGUI.AnvilClickEventHandler(){

                        public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                            if (event.getSlot() == AnvilGUI.AnvilSlot.OUTPUT) {
                                event.setWillClose(false);
                                event.setWillDestroy(true);
                                String name = event.getName();
                                configFile.setValue(name);
                                if (ConfigFile.this.getPath() == TWITTER_CONSUMER_KEY.getPath() || ConfigFile.this.getPath() == TWITTER_CONSUMER_SECRET.getPath() || ConfigFile.this.getPath() == TWITTER_TOKEN_KEY.getPath() || ConfigFile.this.getPath() == TWITTER_TOKEN_SECRET.getPath()) {
                                    IntegrationManager.setup();
                                }
                                ConfigFile.this.sendMessage(inv.getScorpionPlayer());
                                inv.openMenu();
                            } else {
                                event.setWillClose(false);
                                event.setWillDestroy(false);
                            }
                        }
                    });
                    gui.setSlot(AnvilGUI.AnvilSlot.INPUT_LEFT, new Item(configFile.getVariable().getItemStack().getType(), ConfigFile.this.getString().replace('\u00a7', '&')).toItemStack());
                    gui.open();
                } else if (ConfigFile.this.var instanceof VariableItemStack) {
                    CreativeEvent.getLobbyItemsMode().put(inv.getScorpionPlayer().getUUID(), configFile);
                    UHCPlayerManager.getPlayer(inv.getScorpionPlayer()).giveBypassMode();
                    inv.getScorpionPlayer().getPlayer().closeInventory();
                } else {
                    ConfigFile.this.sendMessage(inv.getScorpionPlayer());
                    inv.openMenu();
                }
            }
        });
    }
}

