/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings.config;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.item.Item;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public enum ConfigCategorie {
    UI(1, "Menu Colors", 2, Material.STAINED_GLASS, ChatColor.GOLD),
    ITEMS(2, "Items", 3, Material.STICK, ChatColor.GREEN),
    TEXT_COLORS(3, "Text Colors", 4, Material.SIGN, ChatColor.AQUA),
    COOLDOWN(1, "Cooldown Setup", 2, Material.WATCH, ChatColor.GREEN),
    INGAME(2, "In Game", 3, Material.DIAMOND_SWORD, ChatColor.GOLD),
    FINISH(3, "Finish", 4, Material.EMERALD, ChatColor.AQUA),
    BUNGEE(1, "Bungee", 2, Material.ENDER_PORTAL_FRAME, ChatColor.RED),
    MOTD(2, "MOTD", 3, Material.PAINTING, ChatColor.GOLD),
    LOBBY_SB(1, "Lobby Scoreboard", 2, Material.STAINED_GLASS, ChatColor.GOLD),
    GAME_SB(2, "Game Scoreboard", 3, Material.COBBLESTONE, ChatColor.GOLD),
    KILLS_SB(3, "Kills Scoreboard", 4, Material.DIAMOND_SWORD, ChatColor.GOLD),
    TAB(4, "Tab", 5, Material.ARMOR_STAND, ChatColor.GOLD),
    ACTION_BAR(5, "Action Bar", 6, Material.CHEST, ChatColor.GOLD),
    PLAYER(1, "Players", 2, Material.IRON_SWORD, ChatColor.AQUA),
    SPECTATOR(2, "Spectators", 3, Material.SKULL_ITEM, ChatColor.YELLOW),
    ALERTS(3, "Alerts", 4, Material.REDSTONE_TORCH_ON, ChatColor.RED),
    LOBBY(1, "Lobby", 2, Material.SLIME_BLOCK, ChatColor.GREEN),
    ARENA(2, "Monde en jeu", 3, Material.SANDSTONE, ChatColor.GOLD),
    SPIGOT(3, "Spigot", 4, Material.CAULDRON_ITEM, ChatColor.RED),
    LANGUE(0, "Language", 0, Material.STONE, ChatColor.WHITE),
    DATABASE(1, "Database", 2, Material.COMMAND, ChatColor.RED),
    TWITTER(2, "Twitter", 3, Material.FEATHER, ChatColor.AQUA),
    DISCORD(3, "Discord", 4, Material.SKULL_ITEM, ChatColor.LIGHT_PURPLE),
    ELO(1, "Elo", 2, Material.EMERALD_BLOCK, ChatColor.GREEN),
    STATS(2, "Stats", 3, Material.GOLD_INGOT, ChatColor.GOLD);

    private String name;
    private Material mat;
    private ChatColor color;
    private int categorie;
    private int slot;

    private ConfigCategorie(int categorie, String name, int slot, Material mat, ChatColor color) {
        this.mat = mat;
        this.color = color;
        this.name = name;
        this.categorie = categorie;
        this.slot = slot;
    }

    public int getCategorie() {
        return this.categorie;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public Material getMaterial() {
        return this.mat;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String getColorName() {
        return this.color + this.name;
    }

    public String getCategorieName() {
        return ChatColor.GRAY + "(" + this.color + this.name + ChatColor.GRAY + ")";
    }

    public Item getItem() {
        return new Item(this.mat, this.color + this.name);
    }

    public void addCategorieItem(CustomInventory inv) {
        inv.addCategorieItem(this.categorie, this.slot, this.getItem(), MEnum.SELECTED_MENU.getText(inv.getScorpionPlayer(), new Object[0]), MEnum.SELECTION_MENU.getText(inv.getScorpionPlayer(), new Object[0]));
    }

    public void addSpecialCategorieItem(CustomInventory inv, int main_categorie) {
        inv.addSpecialCategorieItem(this.categorie, this.slot, main_categorie, this.getItem(), MEnum.SELECTED_MENU.getText(inv.getScorpionPlayer(), new Object[0]), MEnum.SELECTION_MENU.getText(inv.getScorpionPlayer(), new Object[0]));
    }

    public static List<ConfigCategorie> getMenusItemsType() {
        return Arrays.asList(UI, ITEMS, TEXT_COLORS);
    }

    public static List<ConfigCategorie> getGestionType() {
        return Arrays.asList(COOLDOWN, INGAME, FINISH);
    }

    public static List<ConfigCategorie> getServerType() {
        return Arrays.asList(BUNGEE, MOTD);
    }

    public static List<ConfigCategorie> getStaffType() {
        return Arrays.asList(PLAYER, SPECTATOR, ALERTS);
    }

    public static List<ConfigCategorie> getWorldType() {
        return Arrays.asList(LOBBY, ARENA, SPIGOT);
    }

    public static List<ConfigCategorie> getScoreboardType() {
        return Arrays.asList(LOBBY_SB, GAME_SB, KILLS_SB, TAB, ACTION_BAR);
    }

    public static List<ConfigCategorie> getIntegrationType() {
        return Arrays.asList(DATABASE, TWITTER, DISCORD);
    }

    public static List<ConfigCategorie> getStatsType() {
        return Arrays.asList(ELO, STATS);
    }
}

