/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings;

import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.entity.EntityItem;
import eu.scorpionltd.uhc.util.item.EnchantItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;

public class SettingsManager {
    private static List<Settings> settings;

    public static void loadSettings() {
        settings = new ArrayList<Settings>();
        for (Values values : Values.values()) {
            new Settings(values.getCategorie(), values.getVariable());
        }
        for (Enum enum_ : EntityItem.values()) {
            ((EntityItem)enum_).addSettings();
        }
        for (Enum enum_ : EnchantItem.values()) {
            ((EnchantItem)enum_).addSettings();
        }
    }

    public static List<Settings> getSettings() {
        return settings;
    }

    public static int getCategories() {
        return (int)Math.ceil(settings.size() / 44) + 1;
    }

    public static List<Settings> getSettings(ValueCategorie cat) {
        return settings.stream().filter(s -> s.getCategorie() == cat).collect(Collectors.toList());
    }

    public static Settings getSettings(String key) {
        return settings.stream().filter(s -> s.getVariable().getKey().equals(key)).findFirst().orElse(null);
    }

    public static Settings getSettings(ValueCategorie cat, Material mat) {
        return settings.stream().filter(s -> s.getCategorie() == cat && s.getVariable().getItemStack().getType().equals((Object)mat)).findFirst().orElse(null);
    }
}

