/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.settings;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.limits.Limits;
import eu.scorpionltd.uhc.manager.settings.limits.LimitsManager;
import eu.scorpionltd.uhc.manager.settings.templates.Template;
import eu.scorpionltd.uhc.manager.settings.templates.TemplateFile;
import eu.scorpionltd.uhc.manager.settings.templates.TemplateManager;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.teams.UHCTeamManager;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.entity.EntityItem;
import eu.scorpionltd.uhc.util.item.ItemUtil;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import eu.scorpionltd.utils.variable.Variable;
import eu.scorpionltd.utils.variable.list.VariableBoolean;
import eu.scorpionltd.utils.variable.list.VariableDouble;
import eu.scorpionltd.utils.variable.list.VariableInteger;
import eu.scorpionltd.utils.variable.list.VariableList;
import eu.scorpionltd.utils.variable.list.VariableMultiBoolean;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Settings {
    private String path;
    private UHCMessage name;
    private Variable var;
    private ValueCategorie cat;

    public Settings(ValueCategorie cat, Variable var) {
        this.cat = cat;
        this.var = var;
        this.path = "variables." + var.getKey();
        if (var instanceof VariableMultiBoolean) {
            VariableMultiBoolean vmb = (VariableMultiBoolean)var;
            for (int i = 0; i < vmb.getNumbers(); ++i) {
                new UHCMessage(this.path + "." + i);
            }
            this.name = new UHCMessage(this.path + ".name");
        } else if (var instanceof VariableInteger) {
            new UHCMessage(this.path + ".type");
            this.name = new UHCMessage(this.path + ".name");
        } else {
            this.name = new UHCMessage(this.path);
        }
        for (Template template : TemplateManager.getTemplates()) {
            TemplateFile file = template.getFile();
            if (!file.contains(this.path)) {
                file.setValue(this.path, this.getValue());
            }
            Object value = file.getObject(this.path);
            template.getValues().put(var.getKey(), value);
            if (!template.isDefault()) continue;
            this.setValue(value);
        }
        SettingsManager.getSettings().add(this);
    }

    public ValueCategorie getCategorie() {
        return this.cat;
    }

    public String getPath() {
        return this.path;
    }

    public String getName(Langue langue) {
        return this.name.getText(langue, new Object[0]);
    }

    public String getName(ScorpionPlayer sp) {
        return this.name.getText(sp, new Object[0]);
    }

    public Variable getVariable() {
        return this.var;
    }

    public void setValue(Object value) {
        if (this.var instanceof VariableBoolean) {
            ((VariableBoolean)this.var).setValue(((Boolean)value).booleanValue());
        }
        if (this.var instanceof VariableInteger) {
            ((VariableInteger)this.var).setValue(((Integer)value).intValue());
        }
        if (this.var instanceof VariableDouble) {
            ((VariableDouble)this.var).setValue(((Double)value).doubleValue());
        }
        if (this.var instanceof VariableMultiBoolean) {
            ((VariableMultiBoolean)this.var).changeValue(((Integer)value).intValue());
        }
        if (this.var instanceof VariableList) {
            ((VariableList)this.var).setList(new ArrayList((List)value));
        }
    }

    public Object getValue() {
        if (this.var instanceof VariableBoolean) {
            return ((VariableBoolean)this.var).isValue();
        }
        if (this.var instanceof VariableInteger) {
            return ((VariableInteger)this.var).getValue();
        }
        if (this.var instanceof VariableDouble) {
            return ((VariableDouble)this.var).getValue();
        }
        if (this.var instanceof VariableMultiBoolean) {
            return ((VariableMultiBoolean)this.var).getValue();
        }
        if (this.var instanceof VariableList) {
            return ((VariableList)this.var).getList();
        }
        return null;
    }

    public String getTextValue(Langue langue) {
        if (this.var instanceof VariableBoolean) {
            return (Boolean)this.getValue() != false ? MEnum.VALUE_ON.getText(langue, new Object[0]) : MEnum.VALUE_OFF.getText(langue, new Object[0]);
        }
        if (this.var instanceof VariableMultiBoolean) {
            return UHCMessage.get(this.path + "." + this.getValue()).getText(langue, new Object[0]);
        }
        if (this.var instanceof VariableInteger) {
            return ChatUtil.getNumberWithText(langue, (Integer)this.getValue(), UHCMessage.get(this.path + ".type"));
        }
        if (this.var instanceof VariableList) {
            return ItemUtil.getListTextItem(((VariableList)this.var).getList());
        }
        return this.getValue().toString();
    }

    public String getTextValue(ScorpionPlayer sp) {
        return this.getTextValue(UHCPlayerManager.getPlayer(sp).getLangue());
    }

    public String getTemplateValue(Langue langue, Template template) {
        Object value = template.getValues().get(this.var.getKey());
        if (this.var instanceof VariableBoolean) {
            return (Boolean)value != false ? MEnum.VALUE_ON.getText(langue, new Object[0]) : MEnum.VALUE_OFF.getText(langue, new Object[0]);
        }
        if (this.var instanceof VariableMultiBoolean) {
            return UHCMessage.get(this.path + "." + this.getValue()).getText(langue, new Object[0]);
        }
        if (this.var instanceof VariableInteger) {
            return ChatUtil.getNumberWithText(langue, (Integer)this.getValue(), UHCMessage.get(this.path + ".type"));
        }
        if (this.var instanceof VariableList) {
            return ItemUtil.getListTextItem((List)value);
        }
        return ChatColor.AQUA + value.toString();
    }

    public String getTemplateValue(ScorpionPlayer sp, Template template) {
        return this.getTemplateValue(UHCPlayerManager.getPlayer(sp).getLangue(), template);
    }

    public void changeValue(ScorpionPlayer sp, Object value) {
        this.setValue(value);
        this.sendMessage(sp);
    }

    public void sendMessage(ScorpionPlayer sp) {
        if (sp == null) {
            return;
        }
        sp.getPlayer().sendMessage(ChatUtil.getConfigPrefix() + (ChatUtil.getConfigPrefix().endsWith(" ") ? "" : " ") + ChatColor.YELLOW + this.getName(sp) + " " + ChatUtil.getArrow() + this.getTextValue(sp) + " " + this.cat.getCategorieName());
    }

    public void addItemStack(ScorpionPlayer sp, ItemStack value) {
        if (!(this.var instanceof VariableList)) {
            return;
        }
        VariableList list = (VariableList)this.var;
        list.add((Object)value);
        if (sp == null) {
            return;
        }
        sp.getPlayer().sendMessage(ChatUtil.getConfigPrefix() + (ChatUtil.getConfigPrefix().endsWith(" ") ? "" : " ") + ChatColor.YELLOW + this.getName(sp) + " " + ChatUtil.getArrow() + ChatColor.GREEN + "+ " + ItemUtil.getTextItem(value) + " " + this.cat.getCategorieName());
    }

    public void removeItemStack(ScorpionPlayer sp, ItemStack value) {
        if (!(this.var instanceof VariableList)) {
            return;
        }
        VariableList list = (VariableList)this.var;
        if (list.getList().contains(value)) {
            list.remove((Object)value);
        }
        if (sp == null) {
            return;
        }
        sp.getPlayer().sendMessage(ChatUtil.getConfigPrefix() + (ChatUtil.getConfigPrefix().endsWith(" ") ? "" : " ") + ChatColor.YELLOW + this.getName(sp) + " " + ChatUtil.getArrow() + ChatColor.RED + "- " + ItemUtil.getTextItem(value) + " " + this.cat.getCategorieName());
    }

    public ItemStack getItem(ScorpionPlayer sp) {
        Item item = new Item(this.var.getItemStack().clone());
        item.setName(this.getName(sp));
        if (this.var instanceof VariableBoolean) {
            item.setAmount((Boolean)this.getValue() != false ? 1 : 0);
            item.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(sp, new Object[0]), " ", MEnum.STATE.getText(sp, new Object[0]) + this.getTextValue(sp)});
        } else if (this.var instanceof VariableMultiBoolean) {
            item.setAmount(((Integer)this.getValue()).intValue());
            item.setLore(new String[]{MEnum.MODIFY_ELEMENT.getText(sp, new Object[0]), " ", MEnum.STATE.getText(sp, new Object[0]) + this.getTextValue(sp)});
        } else if (this.var instanceof VariableInteger) {
            VariableInteger vi = (VariableInteger)this.var;
            String type = UHCMessage.get(this.path + ".type").getText(sp, new Object[0]);
            item.setLore(new String[]{MEnum.LEFT_CLICK.getText(sp, new Object[0]) + MEnum.ADD.getText(sp, new Object[0]) + vi.getGreen() + " " + type, MEnum.RIGHT_CLICK.getText(sp, new Object[0]) + MEnum.REMOVE.getText(sp, new Object[0]) + vi.getGreen() + " " + type, " ", MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getTextValue(sp)});
        }
        if (EntityItem.isEntityValue(this.var.getKey())) {
            item.setDurabilite((short)3);
            item.setTexture(EntityItem.getEntityValue(this.var.getKey()).getTexture());
        }
        return item.toItemStackwithItemFlag(ItemFlag.values());
    }

    public void addItem(final CustomInventory inv, int slot, int categorie) {
        inv.addActionItem(new ActionItem(categorie, categorie == 0, slot, this.getItem(inv.getScorpionPlayer())){

            public void onClick(InventoryClickEvent e) {
                boolean proValues = Settings.this.cat == ValueCategorie.GENERATION_BIOMES_ENABLE || Settings.this.cat == ValueCategorie.GENERATION_BIOMES_CENTER || Settings.this.cat == ValueCategorie.ENTITY_SPECS || Settings.this.cat == ValueCategorie.EFFECT || Settings.this.cat == ValueCategorie.ITEM || Settings.this.var.getKey().equals("border.reduction") || Settings.this.var.getKey().equals("team.teleportation_together") || Settings.this.var.getKey().equals("team.show_prefix");
                boolean bl = proValues;
                if (!UHC.getInstance().isPRO() && proValues) {
                    MEnum.NO_PRO_VERSION.sendTo(inv.getScorpionPlayer(), new Object[0]);
                    return;
                }
                if (Settings.this.var instanceof VariableBoolean) {
                    ((VariableBoolean)Settings.this.var).inverseValue();
                    if (Settings.this.var.getKey().equals("server.playing_host") && UHCPlayerManager.getActualHost() != null) {
                        UHCPlayerManager.getActualHost().setHost(true);
                    }
                } else if (Settings.this.var instanceof VariableMultiBoolean) {
                    ((VariableMultiBoolean)Settings.this.var).changeNext();
                } else if (Settings.this.var instanceof VariableInteger) {
                    if (e.isLeftClick()) {
                        ((VariableInteger)Settings.this.var).addGreen();
                    } else {
                        ((VariableInteger)Settings.this.var).removeGreen();
                    }
                }
                Settings.this.checkSettings(inv.getScorpionPlayer());
                if (Settings.this.var.getKey().startsWith("team.")) {
                    UHCTeamManager.resetTeamSystem();
                }
                Settings.this.sendMessage(inv.getScorpionPlayer());
                inv.openMenu();
            }
        });
    }

    public void addItem(CustomInventory inv, int slot) {
        this.addItem(inv, slot, this.cat.getCategorie());
    }

    public void addNumberModifier(CustomInventory inv, int categorie, int categorieSlot, int defaultItemSlot, boolean isExtended) {
        this.addNumberModifier(inv, categorie, categorieSlot, defaultItemSlot, isExtended, null);
    }

    public void addNumberModifier(CustomInventory inv, int categorie, int categorieSlot, int defaultItemSlot, boolean isExtended, Settings switchValue) {
        ScorpionPlayer sp = inv.getScorpionPlayer();
        Item itemCategorie = new Item(this.var.getItemStack().clone());
        itemCategorie.setName(this.getName(sp));
        itemCategorie.setLore(new String[]{MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getTextValue(sp)});
        inv.addCategorieItem(categorie, categorieSlot, itemCategorie);
        this.addSimpleNumberModifier(inv, categorie, defaultItemSlot, isExtended, switchValue);
    }

    public void addSimpleNumberModifier(final CustomInventory inv, int categorie, int defaultItemSlot, boolean isExtended, final Settings switchValue) {
        ScorpionPlayer sp = inv.getScorpionPlayer();
        final VariableInteger vi = (VariableInteger)this.var;
        String type = UHCMessage.get(this.path + ".type").getText(sp, new Object[0]);
        Item itemDefault = new Item(this.var.getItemStack().clone());
        itemDefault.setName(this.getName(sp));
        if (switchValue != null) {
            itemDefault.setLore(new String[]{MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getTextValue(sp), " ", MEnum.STATE.getText(sp, new Object[0]) + switchValue.getTextValue(sp)});
            inv.addActionItem(new ActionItem(categorie, defaultItemSlot, itemDefault.toItemStackwithItemFlag(ItemFlag.values())){

                public void onClick(InventoryClickEvent e) {
                    ((VariableBoolean)switchValue.getVariable()).inverseValue();
                    Settings.this.checkSettings(inv.getScorpionPlayer());
                    switchValue.sendMessage(inv.getScorpionPlayer());
                    inv.openMenu();
                }
            });
        } else {
            itemDefault.setLore(new String[]{MEnum.VALUE_NUMBER.getText(sp, new Object[0]) + this.getTextValue(sp)});
            inv.addItem(new StaticItem(categorie, defaultItemSlot, itemDefault.toItemStackwithItemFlag(ItemFlag.values())));
        }
        int yellowIncrement = 1;
        if (isExtended) {
            ++yellowIncrement;
            Item removeGreenBlock = new Item(Material.STAINED_CLAY, 5, ChatColor.GREEN + MEnum.REMOVE.getText(sp, new Object[0]) + vi.getGreen() + " " + type);
            inv.addActionItem(new ActionItem(categorie, defaultItemSlot - 1, removeGreenBlock.toItemStack()){

                public void onClick(InventoryClickEvent e) {
                    vi.removeGreen();
                    Settings.this.checkSettings(inv.getScorpionPlayer());
                    Settings.this.sendMessage(inv.getScorpionPlayer());
                    inv.openMenu();
                }
            });
            Item addGreenBlock = new Item(Material.STAINED_CLAY, 5, ChatColor.GREEN + MEnum.ADD.getText(sp, new Object[0]) + vi.getGreen() + " " + type);
            inv.addActionItem(new ActionItem(categorie, defaultItemSlot + 1, addGreenBlock.toItemStack()){

                public void onClick(InventoryClickEvent e) {
                    vi.addGreen();
                    Settings.this.checkSettings(inv.getScorpionPlayer());
                    Settings.this.sendMessage(inv.getScorpionPlayer());
                    inv.openMenu();
                }
            });
        }
        Item removeYellowBlock = new Item(Material.STAINED_CLAY, 4, ChatColor.YELLOW + MEnum.REMOVE.getText(sp, new Object[0]) + vi.getYellow() + " " + type);
        inv.addActionItem(new ActionItem(categorie, defaultItemSlot - yellowIncrement, removeYellowBlock.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                vi.removeYellow();
                Settings.this.checkSettings(inv.getScorpionPlayer());
                Settings.this.sendMessage(inv.getScorpionPlayer());
                inv.openMenu();
            }
        });
        Item addYellowBlock = new Item(Material.STAINED_CLAY, 4, ChatColor.YELLOW + MEnum.ADD.getText(sp, new Object[0]) + vi.getYellow() + " " + type);
        inv.addActionItem(new ActionItem(categorie, defaultItemSlot + yellowIncrement, addYellowBlock.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                vi.addYellow();
                Settings.this.checkSettings(inv.getScorpionPlayer());
                Settings.this.sendMessage(inv.getScorpionPlayer());
                inv.openMenu();
            }
        });
        Item removeRedBlock = new Item(Material.STAINED_CLAY, 14, ChatColor.RED + MEnum.REMOVE.getText(sp, new Object[0]) + vi.getRed() + " " + type);
        inv.addActionItem(new ActionItem(categorie, defaultItemSlot - yellowIncrement - 1, removeRedBlock.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                vi.removeRed();
                Settings.this.checkSettings(inv.getScorpionPlayer());
                Settings.this.sendMessage(inv.getScorpionPlayer());
                inv.openMenu();
            }
        });
        Item addRedBlock = new Item(Material.STAINED_CLAY, 14, ChatColor.RED + MEnum.ADD.getText(sp, new Object[0]) + vi.getRed() + " " + type);
        inv.addActionItem(new ActionItem(categorie, defaultItemSlot + yellowIncrement + 1, addRedBlock.toItemStack()){

            public void onClick(InventoryClickEvent e) {
                vi.addRed();
                Settings.this.checkSettings(inv.getScorpionPlayer());
                Settings.this.sendMessage(inv.getScorpionPlayer());
                inv.openMenu();
            }
        });
    }

    private void checkSettings(ScorpionPlayer player) {
        this.checkBorderMax(player);
        ServerUtil.sendSlotsChangeEvent(this);
        Limits limit = LimitsManager.getLimit(this);
        if (limit == null) {
            return;
        }
        limit.checkSettings(player);
    }

    private void checkBorderMax(ScorpionPlayer player) {
        if (!this.var.getKey().contains("border.size")) {
            return;
        }
        int borderMax = ConfigFile.ARENA_LIMIT_BORDER_MAX.getInteger();
        if (borderMax <= 0) {
            return;
        }
        int value = (Integer)this.getValue();
        if (value < borderMax) {
            return;
        }
        this.setValue(borderMax);
        MEnum.NUMBER_MAX.sendTo(player, new Object[0]);
    }
}

