/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.scenarios;

import eu.scorpionltd.uhc.events.scenario.AssaultBattery;
import eu.scorpionltd.uhc.events.scenario.NoFireWeapons;
import eu.scorpionltd.uhc.events.scenario.Timber;
import eu.scorpionltd.uhc.events.scenario.effets.NoFood;
import eu.scorpionltd.uhc.events.scenario.effets.SuperHeroes;
import eu.scorpionltd.uhc.events.scenario.minage.BloodDiamond;
import eu.scorpionltd.uhc.events.scenario.minage.CatEyes;
import eu.scorpionltd.uhc.events.scenario.minage.CutClean;
import eu.scorpionltd.uhc.events.scenario.minage.DiamondLess;
import eu.scorpionltd.uhc.events.scenario.minage.FastSmelting;
import eu.scorpionltd.uhc.events.scenario.minage.GoldLess;
import eu.scorpionltd.uhc.events.scenario.minage.HasteyBoys;
import eu.scorpionltd.uhc.events.scenario.others.Rush;
import eu.scorpionltd.uhc.events.scenario.others.VanillaPlus;
import eu.scorpionltd.uhc.events.scenario.pve.FireLess;
import eu.scorpionltd.uhc.events.scenario.pve.NoFall;
import eu.scorpionltd.uhc.events.scenario.pvp.NoAnvil;
import eu.scorpionltd.uhc.events.scenario.pvp.NoBookShelf;
import eu.scorpionltd.uhc.events.scenario.pvp.NoBow;
import eu.scorpionltd.uhc.events.scenario.pvp.NoCleanUP;
import eu.scorpionltd.uhc.events.scenario.pvp.NoDiamondArmor;
import eu.scorpionltd.uhc.events.scenario.pvp.NoEnchant;
import eu.scorpionltd.uhc.events.scenario.pvp.NoRod;
import eu.scorpionltd.uhc.events.scenario.pvp.NoSword;
import eu.scorpionltd.uhc.events.scenario.pvp.TimeBomb;
import eu.scorpionltd.uhc.manager.scenarios.Gamemode;
import eu.scorpionltd.uhc.manager.scenarios.Scenario;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ScenarioManager {
    private static List<Scenario> scenarios;

    public static void loadScenarios() {
        scenarios = new ArrayList<Scenario>();
        new CutClean();
        new FastSmelting();
        new HasteyBoys();
        new BloodDiamond();
        new GoldLess();
        new DiamondLess();
        new CatEyes();
        new TimeBomb();
        new NoSword();
        new NoBow();
        new NoRod();
        new NoAnvil();
        new NoBookShelf();
        new NoEnchant();
        new NoDiamondArmor();
        new SuperHeroes();
        new NoFood();
        new FireLess();
        new NoFall();
        new NoFireWeapons();
        new NoCleanUP();
        new Timber();
        new VanillaPlus();
        new Rush();
        new AssaultBattery();
    }

    public static void startScenarios() {
        scenarios.forEach(sc -> {
            if (sc.isEnable()) {
                sc.onStart();
            }
        });
    }

    public static List<Scenario> getScenarios() {
        return scenarios;
    }

    public static int getCategories() {
        return (int)Math.ceil((double)ScenarioManager.getNormalScenarios().size() / 35.0) + 2;
    }

    public static List<Scenario> getNormalScenarios() {
        return scenarios.stream().filter(sc -> !(sc instanceof Gamemode) && !sc.isEnable()).collect(Collectors.toList());
    }

    public static List<Scenario> getActivatedNormalScenarios() {
        return scenarios.stream().filter(sc -> !(sc instanceof Gamemode) && sc.isEnable()).collect(Collectors.toList());
    }

    public static int getActivatedNormalScenariosLines() {
        return (int)Math.ceil((double)ScenarioManager.getActivatedNormalScenarios().size() / 9.0);
    }

    public static List<Scenario> getActivatedScenarios() {
        return scenarios.stream().filter(sc -> sc.isEnable()).collect(Collectors.toList());
    }

    public static int getActivatedScenariosLines() {
        return (int)Math.ceil((double)ScenarioManager.getActivatedScenarios().size() / 9.0);
    }

    public static Scenario getScenario(String name) {
        return scenarios.stream().filter(sc -> sc.getName().equals(name)).findFirst().orElse(null);
    }

    public static boolean isEnable(String name) {
        Scenario sc = ScenarioManager.getScenario(name);
        if (sc == null) {
            return false;
        }
        return sc.isEnable();
    }

    public static List<Gamemode> getGamemodes() {
        return scenarios.stream().filter(sc -> sc instanceof Gamemode).map(sc -> (Gamemode)sc).collect(Collectors.toList());
    }

    public static int getGamemodeLines() {
        return (int)Math.ceil((double)ScenarioManager.getGamemodes().size() / 9.0);
    }

    public static List<Gamemode> getActivatedGamemodes() {
        return scenarios.stream().filter(sc -> sc instanceof Gamemode && sc.isEnable()).map(sc -> (Gamemode)sc).collect(Collectors.toList());
    }

    public static List<Scenario> getActivatedNormalScenario() {
        return scenarios.stream().filter(sc -> !(sc instanceof Gamemode) && sc.isEnable()).collect(Collectors.toList());
    }
}

