/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.scenarios;

import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioCategorie;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import eu.scorpionltd.uhc.manager.settings.templates.Template;
import eu.scorpionltd.uhc.manager.settings.templates.TemplateManager;
import eu.scorpionltd.uhc.ui.config.MenuScenarios;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.utils.inventory.CustomInventory;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Scenario {
    private ItemStack item;
    private String name;
    private boolean isEnable;
    private ScenarioCategorie cat;
    private UHCMessage description;

    public Scenario(String name, ScenarioCategorie cat, ItemStack item) {
        this.name = name;
        this.item = item;
        this.isEnable = false;
        this.cat = cat;
        this.description = new UHCMessage("scenario_description." + name.toLowerCase().replace(" ", "_"));
        Template defaultTemplate = TemplateManager.getDefaultTemplate();
        if (defaultTemplate != null && defaultTemplate.getValues().containsKey("activated_scenarios." + name)) {
            this.inverseValue(null);
        }
        ScenarioManager.getScenarios().add(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription(Langue langue) {
        if (this.description.getBrut(langue).equals("")) {
            return MEnum.DEFAULT_DESC_SC.getText(langue, new Object[0]);
        }
        return this.description.getText(langue, new Object[0]);
    }

    public void setValue(ScorpionPlayer p, boolean value) {
        this.isEnable = value;
        if (this.isEnable) {
            this.onEnable(p);
            MEnum.ENABLE_SCENARIO.sendAll(this.name);
        } else {
            this.onDisable(p);
            MEnum.DISABLE_SCENARIO.sendAll(this.name);
        }
        ServerUtil.sendScenariosChangeEvent(this);
    }

    public void inverseValue(ScorpionPlayer p) {
        this.isEnable = !this.isEnable;
        boolean bl = this.isEnable;
        if (this.isEnable) {
            this.onEnable(p);
            MEnum.ENABLE_SCENARIO.sendAll(this.name);
        } else {
            this.onDisable(p);
            MEnum.DISABLE_SCENARIO.sendAll(this.name);
        }
        ServerUtil.sendScenariosChangeEvent(this);
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public ScenarioCategorie getCategorie() {
        return this.cat;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemStack getViewItemStack(ScorpionPlayer sp) {
        Item stack = new Item(this.item);
        stack.setName(ChatColor.AQUA + this.name);
        Langue langue = UHCPlayerManager.getPlayer(sp).getLangue();
        ArrayList<String> lore = new ArrayList<String>();
        String newmsg = ChatColor.GRAY + "";
        int i = 0;
        for (String bout : this.getDescription(langue).split(" ")) {
            newmsg = newmsg + bout + " ";
            if (i == 8) {
                lore.add(newmsg);
                newmsg = ChatColor.GRAY + "";
                i = 0;
            }
            ++i;
        }
        if (!newmsg.equals(ChatColor.GRAY + "")) {
            lore.add(newmsg);
        }
        stack.setLore(lore);
        return stack.toItemStackwithItemFlag(ItemFlag.values());
    }

    public ItemStack getConfigItemStack(ScorpionPlayer sp) {
        Item stack = new Item(this.item);
        stack.setName(ChatColor.AQUA + this.name);
        Langue langue = UHCPlayerManager.getPlayer(sp).getLangue();
        ArrayList<String> lore = new ArrayList<String>();
        String newmsg = ChatColor.GRAY + "";
        int i = 0;
        for (String bout : this.getDescription(langue).split(" ")) {
            newmsg = newmsg + bout + " ";
            if (i == 8) {
                lore.add(newmsg);
                newmsg = ChatColor.GRAY + "";
                i = 0;
            }
            ++i;
        }
        if (!newmsg.equals(ChatColor.GRAY + "")) {
            lore.add(newmsg);
        }
        lore.add("");
        if (this.isEnable) {
            lore.add(MEnum.LEFT_CLICK.getText(sp, new Object[0]) + MEnum.MODIFY_SC.getText(sp, new Object[0]));
            lore.add(MEnum.RIGHT_CLICK.getText(sp, new Object[0]) + MEnum.DISABLE_SC.getText(sp, new Object[0]));
        } else {
            lore.add(MEnum.ENABLE_SC.getText(sp, new Object[0]));
        }
        stack.setLore(lore);
        return stack.toItemStackwithItemFlag(ItemFlag.values());
    }

    public void addConfigItem(final CustomInventory inv, final int categorie, int slot) {
        inv.addActionItem(new ActionItem(categorie, slot, this.getConfigItemStack(inv.getScorpionPlayer())){

            public void onClick(InventoryClickEvent e) {
                if (!Scenario.this.isEnable || !e.isLeftClick()) {
                    Scenario.this.inverseValue(inv.getScorpionPlayer());
                    new MenuScenarios(inv.getScorpionPlayer(), categorie).openMenu();
                    return;
                }
                Scenario.this.onConfigMenu(inv.getScorpionPlayer());
            }
        });
    }

    public void onEnable(ScorpionPlayer p) {
    }

    public void onStart() {
    }

    public void onDisable(ScorpionPlayer p) {
    }

    public void onConfigMenu(ScorpionPlayer p) {
        MEnum.NO_CONFIG_SCENARIO.sendTo(p, new Object[0]);
    }

    public List<String> onProfileInformations(ScorpionPlayer p, UHCPlayer target) {
        return new ArrayList<String>();
    }
}

