/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.stats;

import eu.scorpionltd.uhc.events.custom.GameTimeEvent;
import eu.scorpionltd.uhc.events.custom.player.GameDeathEvent;
import eu.scorpionltd.uhc.events.custom.player.GameKillEvent;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.entity.EntityUtil;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class StatsEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBreak(BlockBreakEvent e) {
        if (Status.getCurrentStatus().isFinish() || e.getPlayer() == null || e.getBlock() == null || e.getBlock().getType() == null || Metadata.FAKE_DIAMONDS.has(e.getBlock())) {
            return;
        }
        UHCPlayer up = UHCPlayerManager.getPlayer(e.getPlayer().getUniqueId());
        if (!up.isPlaying()) {
            return;
        }
        if (e.getBlock().getType() == Material.DIAMOND_ORE) {
            up.getInfos().addCurrentDiamonds();
        }
        if (e.getBlock().getType() == Material.GOLD_ORE) {
            up.getInfos().addCurrentGolds();
        }
        if (e.getBlock().getType() == Material.IRON_ORE) {
            up.getInfos().addCurrentIrons();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityKill(EntityDeathEvent e) {
        if (Status.getCurrentStatus().isFinish()) {
            return;
        }
        if (e.getEntity() == null || e.getEntity().getType() == null) {
            return;
        }
        if (e.getEntity().getKiller() == null || !(e.getEntity().getKiller() instanceof Player)) {
            return;
        }
        Player killer = e.getEntity().getKiller();
        UHCPlayer up = UHCPlayerManager.getPlayer(killer.getUniqueId());
        if (!up.isPlaying()) {
            return;
        }
        if (EntityUtil.isAnimal(e.getEntity().getType())) {
            up.getInfos().addCurrentAnimals();
        }
        if (EntityUtil.isMonster(e.getEntity().getType())) {
            up.getInfos().addCurrentMonsters();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onGame(GameTimeEvent e) {
        if (Status.getCurrentStatus().isFinish()) {
            return;
        }
        for (UHCPlayer up : UHCPlayerManager.getPlayings()) {
            Player player;
            if (up == null || up.isDead() || !up.isPlaying() || (player = up.getPlayer()) == null || player.isDead() || !player.isOnline() || WorldUtil.isSurface(player.getLocation())) continue;
            up.getInfos().addCurrentCaveTime();
        }
        if (!Values.SERVER_NUMBER_HOST.getBoolean()) {
            return;
        }
        for (UHCPlayer player : UHCPlayerManager.getSpecs()) {
            if (player.getPlayer() == null || !player.getPlayer().isOnline()) continue;
            player.getInfos().addSpecTime();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerKill(GameKillEvent e) {
        if (e.isCancelled()) {
            return;
        }
        PlayerInfos infos = e.getKiller().getInfos();
        infos.addCurrentKills();
        if (infos.getCurrentKills() > infos.getGlobalBestKillstreak()) {
            infos.setBestKillstreak(infos.getCurrentKills());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDeath(GameDeathEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.getDeath().getInfos().addCurrentDeaths();
    }
}

