/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.permissions;

import eu.scorpionltd.uhc.manager.players.permissions.Permission;
import eu.scorpionltd.uhc.manager.players.permissions.PermissionFile;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import java.util.ArrayList;
import java.util.List;

public class PermissionManager {
    private static List<Permission> permissions;
    private static PermissionFile permissionsFile;

    public static void loadPermissions() {
        permissions = new ArrayList<Permission>();
        permissionsFile = new PermissionFile();
        for (Permissions perm : Permissions.values()) {
            perm.setupPermission();
        }
    }

    public static void savePermissions() {
        if (permissions == null) {
            return;
        }
        permissions.forEach(permission -> permission.saveConfig());
        permissionsFile.saveFile();
    }

    public static List<Permission> getPermissions() {
        return permissions;
    }

    public static int getPermissionsSize() {
        return (int)Math.max(Math.ceil((double)permissions.size() / 45.0), 1.0);
    }

    public static PermissionFile getPermissionFile() {
        return permissionsFile;
    }

    public static Permission getPermission(String perm) {
        return permissions.stream().filter(permission -> permission.getPermission().equals(perm)).findFirst().orElse(null);
    }
}

