/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.permissions;

import eu.scorpionltd.uhc.UHC;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class PermissionFile {
    private File file = new File(UHC.getInstance().getDataFolder() + "/game/permissions.yml");
    private FileConfiguration configFile = YamlConfiguration.loadConfiguration((File)this.file);

    public PermissionFile() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create permissions.yml!");
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public void setValue(String path, Object object) {
        this.configFile.set(path, object);
    }

    public boolean getBoolean(String path) {
        if (!this.contains(path)) {
            return false;
        }
        return this.configFile.getBoolean(path);
    }

    public int getInteger(String path) {
        if (!this.contains(path)) {
            return 0;
        }
        return this.configFile.getInt(path);
    }

    public double getDouble(String path) {
        if (!this.contains(path)) {
            return 0.0;
        }
        return this.configFile.getDouble(path);
    }

    public String getString(String path) {
        return this.configFile.getString(path);
    }

    public List<String> getStringList(String path) {
        return this.configFile.getStringList(path);
    }

    public ItemStack getItemStack(String path) {
        return this.configFile.getItemStack(path);
    }

    public boolean contains(String path) {
        return this.configFile.contains(path);
    }

    public void saveFile() {
        try {
            this.configFile.save(this.file);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not save " + this.file.getName() + " !");
        }
    }

    public void reloadFile() {
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.saveFile();
    }
}

