/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.permissions;

import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.PermissionFile;
import eu.scorpionltd.uhc.manager.players.permissions.PermissionManager;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Permission {
    private String permission;
    private boolean hasNeededPermission;
    private boolean hasHost;
    private boolean hasCoHost;
    private boolean hasSpec;
    private boolean hasNotPlaying;
    private UHCMessage nameMessage;
    private UHCMessage descriptionMessage;

    public Permission(String permission, boolean hasNeededPermission, boolean hasHost, boolean hasCoHost, boolean hasSpec, boolean hasNotPlaying) {
        this.permission = permission;
        this.hasNeededPermission = hasNeededPermission;
        this.hasHost = hasHost;
        this.hasCoHost = hasCoHost;
        this.hasSpec = hasSpec;
        this.hasNotPlaying = hasNotPlaying;
        this.nameMessage = new UHCMessage("permissions.name." + permission);
        this.descriptionMessage = new UHCMessage("permissions.description." + permission);
        this.loadConfig();
        PermissionManager.getPermissions().add(this);
    }

    public Permission(String permission) {
        this(permission, true, true, false, false, true);
    }

    public void loadConfig() {
        PermissionFile file = PermissionManager.getPermissionFile();
        if (!file.contains(this.getPath() + ".hasNeededPermission")) {
            return;
        }
        this.hasNeededPermission = file.getBoolean(this.getPath() + ".hasNeededPermission");
        this.hasHost = file.getBoolean(this.getPath() + ".hasHost");
        this.hasCoHost = file.getBoolean(this.getPath() + ".hasCoHost");
        this.hasSpec = file.getBoolean(this.getPath() + ".hasSpec");
        this.hasNotPlaying = file.getBoolean(this.getPath() + ".hasNotPlaying");
    }

    public void saveConfig() {
        PermissionFile file = PermissionManager.getPermissionFile();
        file.setValue(this.getPath() + ".hasNeededPermission", this.hasNeededPermission);
        file.setValue(this.getPath() + ".hasHost", this.hasHost);
        file.setValue(this.getPath() + ".hasCoHost", this.hasCoHost);
        file.setValue(this.getPath() + ".hasSpec", this.hasSpec);
        file.setValue(this.getPath() + ".hasNotPlaying", this.hasNotPlaying);
    }

    public String getPath() {
        return "permissions." + this.permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isHasNeededPermission() {
        return this.hasNeededPermission;
    }

    public void setHasNeededPermission(boolean hasNeededPermission) {
        this.hasNeededPermission = hasNeededPermission;
    }

    public boolean isHasHost() {
        return this.hasHost;
    }

    public void setHasHost(boolean hasHost) {
        this.hasHost = hasHost;
    }

    public boolean isHasCoHost() {
        return this.hasCoHost;
    }

    public void setHasCoHost(boolean hasCoHost) {
        this.hasCoHost = hasCoHost;
    }

    public boolean isHasSpec() {
        return this.hasSpec;
    }

    public void setHasSpec(boolean hasSpec) {
        this.hasSpec = hasSpec;
    }

    public boolean isHasNotPlaying() {
        return this.hasNotPlaying;
    }

    public void setHasNotPlaying(boolean hasNotPlaying) {
        this.hasNotPlaying = hasNotPlaying;
    }

    public boolean isPlayerPerm() {
        return !this.hasCoHost && !this.hasSpec && !this.hasHost;
    }

    public boolean isNoConditionPerm() {
        return this.isPlayerPerm() && !this.hasNotPlaying;
    }

    public boolean hasPerm(UHCPlayer uhcPlayer) {
        return this.hasPerm(uhcPlayer.getPlayer());
    }

    public boolean hasPerm(Player player) {
        if (this.hasNeededPermission && !player.hasPermission(this.permission) && !player.isOp() && !player.hasPermission("supuhc.*")) {
            return false;
        }
        if (this.isNoConditionPerm()) {
            return true;
        }
        UHCPlayer uhcPlayer = UHCPlayerManager.getPlayer(player);
        if (uhcPlayer == null) {
            return true;
        }
        if (this.hasNotPlaying && uhcPlayer.isPlaying()) {
            return false;
        }
        if (this.isPlayerPerm()) {
            return true;
        }
        return this.hasHost && uhcPlayer.isHost() || this.hasCoHost && uhcPlayer.isCoHost() || this.hasSpec && uhcPlayer.isSpec();
    }

    public UHCMessage getNameMessage() {
        return this.nameMessage;
    }

    public UHCMessage getDescriptionMessage() {
        return this.descriptionMessage;
    }

    public ItemStack getItemStack(ScorpionPlayer sp, Material material) {
        Item item = new Item(material, this.nameMessage.getText(sp, new Object[0]));
        ArrayList<String> lore = new ArrayList<String>();
        String newmsg = ChatColor.GRAY + "";
        int i = 0;
        for (String bout : this.descriptionMessage.getText(sp, new Object[0]).split(" ")) {
            newmsg = newmsg + bout + " ";
            if (i == 8) {
                lore.add(newmsg);
                newmsg = ChatColor.GRAY + "";
                i = 0;
            }
            ++i;
        }
        if (!newmsg.equals(ChatColor.GRAY + "")) {
            lore.add(newmsg);
        }
        lore.add("");
        lore.add(ChatColor.GRAY + "Permission: " + ChatColor.AQUA + this.permission);
        item.setLore(lore);
        return item.toItemStackwithItemFlag(ItemFlag.values());
    }
}

