/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.infos;

import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.item.ItemUtil;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerInventory {
    private PlayerInfos infos;
    private Location location;
    private int xp;
    private double health;
    private double maxHealth;
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private List<ItemStack> inventory;
    private List<ItemStack> fullBackpack;

    public PlayerInventory(PlayerInfos infos) {
        this.infos = infos;
        this.location = null;
        this.xp = 0;
        this.health = 0.0;
        this.maxHealth = 0.0;
        this.helmet = null;
        this.chestplate = null;
        this.leggings = null;
        this.boots = null;
        this.inventory = new ArrayList<ItemStack>();
        this.fullBackpack = new ArrayList<ItemStack>();
    }

    public void saveHealth(Player player) {
        this.health = player.getHealth();
        this.maxHealth = player.getMaxHealth();
    }

    public void giveHealth(Player player) {
        if (this.maxHealth != 0.0) {
            player.setMaxHealth(this.maxHealth);
        }
        if (this.health != 0.0) {
            player.setHealth(this.health);
        }
    }

    public void savePlayer(Player player) {
        if (player == null) {
            return;
        }
        this.location = player.getLocation().clone();
        this.xp = player.getLevel() + 1;
        if (player.getInventory() == null) {
            return;
        }
        ItemStack helmet = player.getInventory().getHelmet();
        this.helmet = helmet == null || helmet.getType() == null || helmet.getType() == Material.AIR ? null : helmet.clone();
        ItemStack chestplate = player.getInventory().getChestplate();
        this.chestplate = chestplate == null || chestplate.getType() == null || chestplate.getType() == Material.AIR ? null : chestplate.clone();
        ItemStack leggings = player.getInventory().getLeggings();
        this.leggings = leggings == null || leggings.getType() == null || leggings.getType() == Material.AIR ? null : leggings.clone();
        ItemStack boots = player.getInventory().getBoots();
        this.boots = boots == null || boots.getType() == null || boots.getType() == Material.AIR ? null : boots.clone();
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        for (ItemStack i : player.getInventory().getContents()) {
            if (i == null || i.getType() == null || i.getType() == Material.AIR) continue;
            inventory.add(i.clone());
        }
        this.inventory = inventory;
    }

    public void givePlayer(Player player) {
        player.setLevel(this.xp);
        if (this.helmet != null) {
            player.getInventory().setHelmet(this.helmet);
        }
        if (this.chestplate != null) {
            player.getInventory().setChestplate(this.chestplate);
        }
        if (this.leggings != null) {
            player.getInventory().setLeggings(this.leggings);
        }
        if (this.boots != null) {
            player.getInventory().setBoots(this.boots);
        }
        for (ItemStack item : this.inventory) {
            player.getInventory().addItem(new ItemStack[]{item});
        }
        player.updateInventory();
    }

    public void dropPlayer(Location location) {
        List<ItemStack> noDrops = Values.INVENTORY_NO_DROP.getListItemStack();
        ArrayList<ItemStack> dropItems = new ArrayList<ItemStack>();
        dropItems.addAll(this.inventory);
        dropItems.addAll(this.getArmors());
        dropItems.addAll(Values.INVENTORY_DEATH.getListItemStack());
        if (Values.RULES_GOLDEN_APPLE.getBoolean()) {
            dropItems.add(new ItemStack(Material.GOLDEN_APPLE));
        }
        if (Values.RULES_GOLDEN_HEAD.getBoolean()) {
            dropItems.add(ItemUtil.getGoldenHead());
        }
        if (Values.RULES_HEAD.getBoolean()) {
            dropItems.add(ItemUtil.getHead(this.infos.getName()));
        }
        if (!noDrops.isEmpty()) {
            for (Object raw : new ArrayList(dropItems)) {
                if (!(raw instanceof ItemStack)) continue;
                ItemStack drop = (ItemStack)raw;
                ItemStack copy = drop.clone();
                copy.setAmount(1);
                if (noDrops.contains(copy)) {
                    dropItems.remove(drop);
                    continue;
                }
                if (drop.getType() == Material.BANNER || drop.getType() == Material.FIREWORK) {
                    ItemStack compare = new ItemStack(drop.getType());
                    if (!noDrops.contains(compare)) continue;
                    dropItems.remove(drop);
                    continue;
                }
                if (!ItemUtil.isDamageable(copy.getType())) continue;
                copy.setDurability((short)0);
                if (!noDrops.contains(copy)) continue;
                dropItems.remove(drop);
            }
        }
        if (location == null) {
            location = this.location;
        }
        for (ItemStack stack : dropItems) {
            InventoryUtil.dropItem(location, stack);
        }
    }

    public PlayerInfos getInfos() {
        return this.infos;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getExp() {
        return this.xp;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public ItemStack getChestplate() {
        return this.chestplate;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public List<ItemStack> getArmors() {
        ArrayList<ItemStack> armor = new ArrayList<ItemStack>();
        if (this.helmet != null) {
            armor.add(this.helmet);
        }
        if (this.chestplate != null) {
            armor.add(this.chestplate);
        }
        if (this.leggings != null) {
            armor.add(this.leggings);
        }
        if (this.boots != null) {
            armor.add(this.boots);
        }
        return armor;
    }

    public List<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isEmptyInventory() {
        return this.inventory.isEmpty();
    }

    public List<ItemStack> getFullBackpack() {
        return this.fullBackpack;
    }

    public boolean isEmptyFullBackpack() {
        return this.fullBackpack.isEmpty();
    }

    public int getFullBackpackLines() {
        return (int)Math.min(6.0, Math.max(2.0, Math.ceil((double)this.fullBackpack.size() / 9.0) + 1.0));
    }

    public void addItemFullBackpack(ItemStack stack) {
        this.fullBackpack.add(stack);
    }

    public void removeItemFullBackpack(ItemStack stack) {
        if (!this.fullBackpack.contains(stack)) {
            return;
        }
        this.fullBackpack.remove(stack);
    }
}

