/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.config;

import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;

public class Stat {
    private String name;
    private Object init;
    private Object global;
    private Object current;
    private int statType;
    private boolean isTotal;
    private boolean isCompare;

    public Stat(PlayerInfos infos, String name, Object init, int statType, boolean isTotal, boolean isCompare) {
        this.name = name;
        this.init = init;
        this.global = init;
        this.current = init;
        this.statType = statType;
        this.isTotal = isTotal;
        this.isCompare = isCompare;
        infos.getStats().add(this);
    }

    public Stat(PlayerInfos infos, String name, Object init, int statType, boolean isTotal) {
        this(infos, name, init, statType, true, false);
    }

    public Stat(PlayerInfos infos, String name, Object init, int statType) {
        this(infos, name, init, statType, true, false);
    }

    public Stat(PlayerInfos infos, String name, Object init) {
        this(infos, name, init, 0, true, false);
    }

    public Stat(PlayerInfos infos, String name) {
        this(infos, name, 0, 0, true, false);
    }

    public void reset(Object value) {
        this.init = value;
        this.global = value;
        this.current = value;
    }

    public void reset() {
        this.reset(this.init);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getInit() {
        return this.init;
    }

    public void setInit(Object init) {
        this.init = init;
    }

    public Object getGlobal() {
        return this.global;
    }

    public int getGlobalInt() {
        return (Integer)this.global;
    }

    public double getGlobalDouble() {
        return (Double)this.global;
    }

    public String getGlobalString() {
        return (String)this.global;
    }

    public void setGlobal(Object global) {
        this.global = global;
    }

    public void addGlobalInt(int value) {
        this.global = this.getGlobalInt() + value;
    }

    public void removeGlobalInt(int value) {
        this.global = this.getGlobalInt() - value;
    }

    public Object getCurrent() {
        return this.current;
    }

    public int getCurrentInt() {
        return (Integer)this.current;
    }

    public double getCurrentDouble() {
        return (Double)this.current;
    }

    public String getCurrentString() {
        return (String)this.current;
    }

    public void setCurrent(Object current) {
        this.current = current;
    }

    public void addCurrentInt(int value) {
        this.current = this.getCurrentInt() + value;
    }

    public void removeCurrentInt(int value) {
        this.current = this.getCurrentInt() - value;
    }

    public Object getTotal() {
        if (this.isCompare) {
            if (this.current instanceof Integer && this.getGlobalInt() > this.getCurrentInt()) {
                return this.getGlobalInt();
            }
            if (this.current instanceof Double && this.getGlobalDouble() > this.getCurrentDouble()) {
                return this.getGlobalDouble();
            }
        }
        if (!this.isTotal) {
            return this.getCurrent();
        }
        if (this.current instanceof Integer) {
            return this.getGlobalInt() + this.getCurrentInt();
        }
        if (this.current instanceof Double) {
            return this.getGlobalDouble() + this.getCurrentDouble();
        }
        if (this.current instanceof String) {
            return this.getGlobal();
        }
        return this.getCurrent();
    }

    public int getStatType() {
        return this.statType;
    }

    public boolean isGlobal() {
        return this.statType == 2;
    }

    public boolean isServerHost() {
        return this.statType == 1;
    }

    public boolean isServerStat() {
        return this.statType == 0;
    }

    public boolean isTotal() {
        return this.isTotal;
    }

    public boolean isCompare() {
        return this.isCompare;
    }
}

