/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.config;

import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.players.config.Stat;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PlayerInfos {
    private UUID uuid;
    private int deconnexionTime;
    private List<Stat> stats;

    public PlayerInfos(UUID uuid) {
        this.uuid = uuid;
        this.deconnexionTime = 0;
        this.stats = new ArrayList<Stat>();
        new Stat(this, "name", "Unknown", 2, false);
        new Stat(this, "twitterName", "Unknown", 2, false);
        Langue defaultLangue = LangueManager.getDefaultLangue();
        String langueKey = "FR";
        if (defaultLangue != null) {
            langueKey = defaultLangue.getFlag().getKey();
        }
        new Stat(this, "langue", langueKey, 2, false);
        new Stat(this, "prewhitelist", 0, 2, true);
        new Stat(this, "wins");
        new Stat(this, "games");
        new Stat(this, "bestLongshot", 0.0, 0, false, true);
        new Stat(this, "bestKillstreak", 0, 0, false, true);
        new Stat(this, "elo", ConfigFile.ELO_DEFAULT.getInteger(), 0, false);
        new Stat(this, "hostGames", 0, 1, true);
        new Stat(this, "hostTime", 0, 1, true);
        new Stat(this, "globalKills");
        new Stat(this, "globalDeaths");
        new Stat(this, "globalDiamonds");
        new Stat(this, "globalGolds");
        new Stat(this, "globalIrons");
        new Stat(this, "globalAnimals");
        new Stat(this, "globalMonsters");
        new Stat(this, "globalCaveTime");
    }

    public List<Stat> getStats() {
        return this.stats;
    }

    public Stat getStat(String name) {
        return this.stats.stream().filter(stat -> stat.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getDeconnexionTime() {
        return this.deconnexionTime;
    }

    public void setDeconnexionTime(int value) {
        this.deconnexionTime = value;
    }

    public void addDeconnexionTime() {
        ++this.deconnexionTime;
    }

    public String getName() {
        return this.getStat("name").getGlobalString();
    }

    public void setName(String name) {
        this.getStat("name").setGlobal(name);
    }

    public String getTwitterName() {
        return this.getStat("twitterName").getGlobalString();
    }

    public void setTwitterName(String twitterName) {
        this.getStat("twitterName").setGlobal(twitterName);
    }

    public Langue getLangue() {
        return LangueManager.getLangue(this.getStat("langue").getGlobalString());
    }

    public void setLangue(Langue langue) {
        this.getStat("langue").setGlobal(langue.getFlag().getKey());
    }

    public int getPreWhitelist() {
        return this.getStat("prewhitelist").getGlobalInt();
    }

    public void addPreWhitelist(int nombre) {
        this.getStat("prewhitelist").addGlobalInt(nombre);
    }

    public void addPreWhitelist() {
        this.addPreWhitelist(1);
    }

    public void removePreWhitelist(int nombre) {
        this.getStat("prewhitelist").removeGlobalInt(nombre);
    }

    public boolean hasPreWhitelist() {
        return this.getPreWhitelist() > 0;
    }

    public int getGlobalWins() {
        return this.getStat("wins").getGlobalInt();
    }

    public void addWins() {
        this.getStat("wins").addCurrentInt(1);
    }

    public int getGlobalGames() {
        return this.getStat("games").getGlobalInt();
    }

    public void setGames(int value) {
        this.getStat("games").setCurrent(value);
    }

    public void addGames() {
        this.getStat("games").addCurrentInt(1);
    }

    public float getWinRatio() {
        if (this.getGlobalGames() == 0) {
            return this.getGlobalWins();
        }
        return (float)this.getGlobalWins() / (float)this.getGlobalGames();
    }

    public String getWinRatioText() {
        return String.format("%.2f", Float.valueOf(this.getWinRatio()));
    }

    public double getGlobalBestLongshot() {
        return this.getStat("bestLongshot").getGlobalDouble();
    }

    public void setBestLongshot(double value) {
        this.getStat("bestLongshot").setCurrent(value);
    }

    public int getGlobalBestKillstreak() {
        return this.getStat("bestKillstreak").getGlobalInt();
    }

    public void setBestKillstreak(int value) {
        this.getStat("bestKillstreak").setCurrent(value);
    }

    public int getElo() {
        return this.getStat("elo").getCurrentInt();
    }

    public void addElo(int nombre) {
        this.getStat("elo").addCurrentInt(nombre);
    }

    public void removeElo(int nombre) {
        this.getStat("elo").removeCurrentInt(nombre);
    }

    public int getGlobalHostGames() {
        return this.getStat("hostGames").getGlobalInt();
    }

    public void addHostGames() {
        this.getStat("hostGames").addCurrentInt(1);
    }

    public int getGlobalSpecTime() {
        return this.getStat("hostTime").getGlobalInt();
    }

    public void addSpecTime() {
        this.getStat("hostTime").addCurrentInt(1);
    }

    public int getGlobalKills() {
        return this.getStat("globalKills").getGlobalInt();
    }

    public int getGlobalDeaths() {
        return this.getStat("globalDeaths").getGlobalInt();
    }

    public int getGlobalDiamonds() {
        return this.getStat("globalDiamonds").getGlobalInt();
    }

    public int getGlobalGolds() {
        return this.getStat("globalGolds").getGlobalInt();
    }

    public int getGlobalIrons() {
        return this.getStat("globalIrons").getGlobalInt();
    }

    public int getGlobalAnimals() {
        return this.getStat("globalAnimals").getGlobalInt();
    }

    public int getGlobalMonsters() {
        return this.getStat("globalMonsters").getGlobalInt();
    }

    public int getGlobalCaveTime() {
        return this.getStat("globalCaveTime").getGlobalInt();
    }

    public float getKillRatio() {
        if (this.getGlobalDeaths() == 0) {
            return this.getGlobalKills();
        }
        return (float)this.getGlobalKills() / (float)this.getGlobalDeaths();
    }

    public String getKillRatioText() {
        return String.format("%.2f", Float.valueOf(this.getKillRatio()));
    }

    public int getCurrentKills() {
        return this.getStat("globalKills").getCurrentInt();
    }

    public void addCurrentKills() {
        this.getStat("globalKills").addCurrentInt(1);
    }

    public int getCurrentDeaths() {
        return this.getStat("globalDeaths").getCurrentInt();
    }

    public void addCurrentDeaths() {
        this.getStat("globalDeaths").addCurrentInt(1);
    }

    public int getCurrentDiamonds() {
        return this.getStat("globalDiamonds").getCurrentInt();
    }

    public void addCurrentDiamonds() {
        this.getStat("globalDiamonds").addCurrentInt(1);
    }

    public int getCurrentGolds() {
        return this.getStat("globalGolds").getCurrentInt();
    }

    public void addCurrentGolds() {
        this.getStat("globalGolds").addCurrentInt(1);
    }

    public int getCurrentIrons() {
        return this.getStat("globalIrons").getCurrentInt();
    }

    public void addCurrentIrons() {
        this.getStat("globalIrons").addCurrentInt(1);
    }

    public int getCurrentAnimals() {
        return this.getStat("globalAnimals").getCurrentInt();
    }

    public void addCurrentAnimals() {
        this.getStat("globalAnimals").addCurrentInt(1);
    }

    public int getCurrentMonsters() {
        return this.getStat("globalMonsters").getCurrentInt();
    }

    public void addCurrentMonsters() {
        this.getStat("globalMonsters").addCurrentInt(1);
    }

    public int getCurrentCaveTime() {
        return this.getStat("globalCaveTime").getCurrentInt();
    }

    public void addCurrentCaveTime() {
        this.getStat("globalCaveTime").addCurrentInt(1);
    }

    public void resetAll() {
        this.stats.forEach(stat -> {
            if (stat.getName() == "elo") {
                stat.reset(ConfigFile.ELO_DEFAULT.getInteger());
            } else {
                stat.reset();
            }
        });
        DatabaseManager.database.onSaveAllAccount();
    }
}

