/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players.config;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class PlayerFile {
    private File file = new File(UHC.getInstance().getDataFolder() + "/players.yml");
    private FileConfiguration configFile = YamlConfiguration.loadConfiguration((File)this.file);

    public PlayerFile() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create players.yml!");
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public void setValue(String path, Object object) {
        this.configFile.set(path, object);
    }

    public Langue getLangue(String path) {
        if (!this.contains(path)) {
            return LangueManager.getDefaultLangue();
        }
        Langue langue = LangueManager.getLangue(this.getString(path));
        if (langue == null) {
            return LangueManager.getDefaultLangue();
        }
        return langue;
    }

    public int getInteger(String path) {
        if (!this.contains(path)) {
            return 0;
        }
        return this.configFile.getInt(path);
    }

    public double getDouble(String path) {
        if (!this.contains(path)) {
            return 0.0;
        }
        return this.configFile.getDouble(path);
    }

    public int getElo(String path) {
        if (!this.contains(path)) {
            return ConfigFile.ELO_DEFAULT.getInteger();
        }
        return this.configFile.getInt(path);
    }

    public String getString(String path) {
        return this.configFile.getString(path);
    }

    public ItemStack getItemStack(String path) {
        return this.configFile.getItemStack(path);
    }

    public boolean contains(String path) {
        return this.configFile.contains(path);
    }

    public void saveFile() {
        try {
            this.configFile.save(this.file);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not save " + this.file.getName() + " !");
        }
    }

    public void reloadFile() {
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.saveFile();
    }
}

