/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players;

import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class UHCPlayerManager {
    private static int prewhitelistedPlayers;
    private static List<UHCPlayer> uhcPlayers;
    private static List<PlayerInfos> playerInfos;

    public static void loadPlayers() {
        prewhitelistedPlayers = 0;
        uhcPlayers = new ArrayList<UHCPlayer>();
        playerInfos = new ArrayList<PlayerInfos>();
        DatabaseManager.database.onAllUUID().forEach(r -> playerInfos.add(DatabaseManager.database.onLoadAccount((UUID)r)));
    }

    public static void savePlayers() {
        if (ConfigFile.DATABASE_DYNAMIC_UPDATE.getBoolean()) {
            return;
        }
        uhcPlayers.forEach(player -> DatabaseManager.getDatabase().onReloadAccount(player.getUUID()));
    }

    public static List<UHCPlayer> getAllPlayers() {
        return uhcPlayers;
    }

    public static void addPlayer(UHCPlayer up) {
        uhcPlayers.add(up);
    }

    public static void removePlayer(UUID uuid) {
        uhcPlayers.remove(UHCPlayerManager.getPlayer(uuid));
    }

    public static boolean havePlayer(ScorpionPlayer sp) {
        return uhcPlayers.stream().anyMatch(player -> player.getUUID().equals(sp.getUUID()));
    }

    public static List<UHCPlayer> getStaffwith(Permissions perm) {
        return uhcPlayers.stream().filter(player -> player.getPlayer() != null && perm.hasPerm(player.getPlayer())).collect(Collectors.toList());
    }

    public static List<UHCPlayer> getPlayings() {
        return uhcPlayers.stream().filter(player -> player.isPlaying()).collect(Collectors.toList());
    }

    public static List<UHCPlayer> getOnlinePlayings() {
        return uhcPlayers.stream().filter(player -> player.getPlayer() != null && player.isPlaying()).collect(Collectors.toList());
    }

    public static List<UHCPlayer> getListPlayer(Set<UUID> players) {
        return uhcPlayers.stream().filter(player -> players.contains(player.getUUID())).collect(Collectors.toList());
    }

    public static UHCPlayer getPlayer(UUID uuid) {
        return uhcPlayers.stream().filter(player -> player.getUUID().equals(uuid)).findFirst().orElse(null);
    }

    public static UHCPlayer getPlayer(String name) {
        return uhcPlayers.stream().filter(player -> player.getName().equals(name)).findFirst().orElse(null);
    }

    public static UHCPlayer getPlayer(Player p) {
        return UHCPlayerManager.getPlayer(p.getUniqueId());
    }

    public static UHCPlayer getPlayer(ScorpionPlayer p) {
        return UHCPlayerManager.getPlayer(p.getUUID());
    }

    public static List<UHCPlayer> getOnlineUHCPlayers() {
        return uhcPlayers.stream().filter(player -> player.getPlayer() != null && player.getPlayer().isOnline()).collect(Collectors.toList());
    }

    public static List<Player> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().filter(player -> player != null && player.isOnline()).collect(Collectors.toList());
    }

    public static List<Player> getPlayingsPlayer() {
        return Bukkit.getOnlinePlayers().stream().filter(player -> UHCPlayerManager.getPlayer(player) != null && UHCPlayerManager.getPlayer(player).isPlaying()).collect(Collectors.toList());
    }

    public static List<UHCPlayer> getSpecs() {
        return uhcPlayers.stream().filter(player -> player.isHost() || player.isSpec()).collect(Collectors.toList());
    }

    public static boolean isActualHost(Player p) {
        if (UHCPlayerManager.getActualHost() == null) {
            return false;
        }
        return UHCPlayerManager.getActualHost().getUUID().equals(p.getUniqueId());
    }

    public static UHCPlayer getActualHost() {
        return uhcPlayers.stream().filter(player -> player.isHost()).findFirst().orElse(null);
    }

    public static boolean hasKill() {
        return uhcPlayers.stream().anyMatch(player -> player.getInfos().getCurrentKills() > 0);
    }

    public static int getPlayersNumber() {
        return UHCPlayerManager.getPlayings().size();
    }

    public static int getPlayersConnectedNumber() {
        return UHCPlayerManager.getPlayingsPlayer().size();
    }

    public static void addPreWhitelistNumber() {
        ++prewhitelistedPlayers;
    }

    public static int getPreWhitelistNumber() {
        return prewhitelistedPlayers;
    }

    public static UHCPlayer getRandomPlayer() {
        List<UHCPlayer> players = UHCPlayerManager.getPlayings();
        return players.get(new Random().nextInt(players.size()));
    }

    public static List<PlayerInfos> getPlayerInfos() {
        return playerInfos;
    }

    public static PlayerInfos getInfos(UUID uuid) {
        return playerInfos.stream().filter(infos -> infos.getUUID().equals(uuid)).findFirst().orElse(null);
    }

    public static PlayerInfos getInfos(String name) {
        return playerInfos.stream().filter(infos -> infos.getUUID().equals(Bukkit.getOfflinePlayer((String)name).getUniqueId())).findFirst().orElse(null);
    }

    public static boolean containsInfos(UUID uuid) {
        return playerInfos.stream().anyMatch(infos -> infos.getUUID().equals(uuid));
    }

    static {
        uhcPlayers = null;
        playerInfos = null;
    }
}

