/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.players;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.manager.players.infos.PlayerInventory;
import eu.scorpionltd.uhc.manager.players.infos.PlayerModifiers;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class UHCPlayer {
    private ScorpionPlayer sp;
    private PlayerInfos infos;
    private boolean isPlaying;
    private boolean isDead;
    private boolean isDeconnecting;
    private boolean isHost;
    private boolean isSpec;
    private boolean bypassMode;
    private boolean isCoHost;
    private PlayerInventory playerInventory;
    private PlayerModifiers playerModifiers;

    public UHCPlayer(ScorpionPlayer sp) {
        this.sp = sp;
        PlayerInfos info = UHCPlayerManager.getInfos(sp.getUUID());
        if (info != null) {
            this.infos = info;
        } else {
            this.infos = new PlayerInfos(sp.getUUID());
            UHCPlayerManager.getPlayerInfos().add(this.infos);
        }
        this.infos.setName(sp.getPlayer().getName());
        this.isPlaying = false;
        this.isDead = false;
        this.isDeconnecting = false;
        this.bypassMode = false;
        this.isHost = false;
        this.isSpec = false;
        this.isCoHost = false;
        this.playerInventory = new PlayerInventory(this.infos);
        this.playerModifiers = new PlayerModifiers();
        UHCPlayerManager.addPlayer(this);
    }

    public ScorpionPlayer getScorpionPlayer() {
        return this.sp;
    }

    public UUID getUUID() {
        return this.sp.getUUID();
    }

    public String getName() {
        return this.infos.getName();
    }

    public Player getPlayer() {
        return this.sp.getPlayer();
    }

    public String getRankName() {
        return this.sp.getPlayer().getDisplayName();
    }

    public String getTeamPrefix() {
        if (!Values.TEAM_SHOW_PREFIX.getBoolean()) {
            return "";
        }
        UHCTeam team = UHC.getTeam(this.sp.getUUID());
        if (team == null) {
            return "";
        }
        return team.getPrefix().getPrefixName();
    }

    public PlayerInfos getInfos() {
        return this.infos;
    }

    public boolean isMuted() {
        return false;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean value) {
        this.isPlaying = value;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean value) {
        this.isDead = value;
        this.setPlaying(!this.isDead);
    }

    public boolean isDeconnecting() {
        return this.isDeconnecting;
    }

    public void setDeconnecting(boolean value) {
        this.isDeconnecting = value;
    }

    public boolean isHost() {
        return this.isHost;
    }

    public void setHost(boolean value) {
        this.isHost = value;
        this.isPlaying = Values.SERVER_PLAYING_HOST.getBoolean() ? true : !this.isHost;
        this.isSpec = false;
    }

    public boolean isSpec() {
        return this.isSpec;
    }

    public void setSpec(boolean value) {
        this.isSpec = value;
        this.isPlaying = !this.isSpec;
        this.isHost = false;
    }

    public boolean isCoHost() {
        return this.isCoHost;
    }

    public void setCoHost(boolean value) {
        this.isCoHost = value;
        this.isPlaying = Values.SERVER_PLAYING_HOST.getBoolean() ? true : !this.isCoHost;
        this.isSpec = false;
    }

    public boolean isBypassMode() {
        return this.bypassMode;
    }

    public void setBypassMode(boolean value) {
        this.bypassMode = value;
    }

    public void inverseBypassMode() {
        this.bypassMode = !this.bypassMode;
    }

    public void giveBypassMode() {
        this.inverseBypassMode();
        MEnum.BYPASS_USE.send(this, this.bypassMode ? MEnum.VALUE_ON.getText(this, new Object[0]) : MEnum.VALUE_OFF.getText(this, new Object[0]));
        if (Status.getCurrentStatus() == Status.IN_GAME) {
            this.setPlaying(!this.bypassMode);
            return;
        }
        Player player = this.getPlayer();
        if (this.bypassMode) {
            player.setGameMode(GameMode.CREATIVE);
            player.getInventory().clear();
            player.updateInventory();
        } else {
            player.teleport(LobbyUtil.getLobbyLocation());
            InventoryUtil.giveJoinItems(this);
            player.setGameMode(GameMode.ADVENTURE);
        }
    }

    public Langue getLangue() {
        return this.infos.getLangue();
    }

    public void setLangue(Langue value) {
        this.infos.setLangue(value);
    }

    public PlayerInventory getInventory() {
        return this.playerInventory;
    }

    public Location getLastLocation() {
        return this.playerInventory.getLocation();
    }

    public PlayerModifiers getModifiers() {
        return this.playerModifiers;
    }
}

