/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.modules;

import eu.scorpionltd.API;
import eu.scorpionltd.licence.Web;
import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.modules.Module;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.UnknownDependencyException;

public class ModuleManager {
    private static List<Module> modules;

    public static void loadModules() {
        List<File> files = ModuleManager.getModuleFiles();
        modules = new ArrayList<Module>();
        if (files.isEmpty()) {
            return;
        }
        files.forEach(f -> {
            try {
                Plugin load = UHC.getInstance().getPluginLoader().loadPlugin(f);
                UHC.getInstance().getPluginLoader().enablePlugin(load);
                new Module(load);
                API.getLicenceManager().loadPlugin(load);
            }
            catch (InvalidPluginException | UnknownDependencyException e) {
                e.printStackTrace();
            }
        });
    }

    public static void missingModules() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)UHC.getInstance(), new Runnable(){

            @Override
            public void run() {
                List allowed = API.getLicenceManager().getAuthorizedModules("modules-uhc");
                for (Object raw : allowed) {
                    String module;
                    if (!(raw instanceof String) || ModuleManager.containsModule(module = (String)raw)) continue;
                    File file = new File(UHC.getInstance().getDataFolder(), module + ".jar");
                    Web.downloadPluginFile((String)"ScorpionLTD-UHC", (String)(module + ".jar"), (File)file);
                }
            }
        });
    }

    public static void unloadModules() {
        modules.forEach(module -> UHC.getInstance().getPluginLoader().disablePlugin(module.getPlugin()));
        modules.clear();
    }

    public static void reloadModules() {
        ModuleManager.unloadModules();
        ScenarioManager.loadScenarios();
        ModuleManager.loadModules();
        MEnum.RESET_MODULES.sendAll(new Object[0]);
    }

    public static List<File> getModuleFiles() {
        List<Object> filesName = new ArrayList();
        if (Files.notExists(Paths.get(UHC.getInstance().getDataFolder() + "/modules", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(Paths.get(UHC.getInstance().getDataFolder() + "/modules", new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (Stream<Path> walk = Files.walk(Paths.get(UHC.getInstance().getDataFolder() + "/modules", new String[0]), new FileVisitOption[0]);){
            filesName = walk.map(x -> x.toString()).filter(f -> f.endsWith(".jar")).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<File>();
        }
        ArrayList<File> files = new ArrayList<File>();
        filesName.forEach(name -> files.add(new File((String)name)));
        return files;
    }

    public static List<Module> getModules() {
        return modules;
    }

    public static int getModulesLines() {
        return (int)Math.ceil((double)ModuleManager.getModules().size() / 9.0);
    }

    public static boolean containsModule(String name) {
        boolean result = false;
        for (Module module : modules) {
            if (!module.getName().equals(name)) continue;
            result = true;
        }
        return result;
    }

    public static Module getModule(String name) {
        for (Module module : modules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }
}

