/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.langues.msg;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.DeathCause;
import eu.scorpionltd.uhc.util.server.enums.Pregen;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistStatus;
import java.util.ArrayList;
import java.util.List;

public class UHCMessageManager {
    private static List<UHCMessage> messages;

    public static void loadMessages() {
        messages = new ArrayList<UHCMessage>();
        for (MEnum mEnum : MEnum.values()) {
            new UHCMessage(mEnum.getKey());
        }
        for (Enum enum_ : Status.values()) {
            new UHCMessage(((Status)enum_).getKey());
        }
        for (Enum enum_ : Pregen.values()) {
            new UHCMessage(((Pregen)enum_).getKey());
        }
        for (Enum enum_ : WhitelistStatus.values()) {
            new UHCMessage(((WhitelistStatus)enum_).getKey());
        }
        DeathCause.setupMessages();
        ConfigFile.setDefault(UHC.getInstance());
        for (Enum enum_ : ConfigFile.values()) {
            ((ConfigFile)enum_).setupMessages();
        }
        LangueManager.getLangues().forEach(langue -> langue.getFile().saveFile());
    }

    public static void reloadMessages() {
        LangueManager.getLangues().forEach(langue -> langue.getFile().reloadFile());
        messages.forEach(message -> message.reload());
        LangueManager.getLangues().forEach(langue -> langue.getFile().saveFile());
        MEnum.RESET_MESSAGES.sendAll(new Object[0]);
    }

    public static List<UHCMessage> getMessages() {
        return messages;
    }

    public static List<UHCMessage> getMessagesByFiles(String path) {
        ArrayList<UHCMessage> list = new ArrayList<UHCMessage>();
        for (UHCMessage message : messages) {
            if (path != "" && !message.getKey().startsWith(path)) continue;
            list.add(message);
        }
        return list;
    }

    public static int getNumberCategories(String path) {
        int numberFiles = UHCMessageManager.getFiles(path).size() + UHCMessageManager.getFinalMessages(path).size();
        return (int)Math.ceil((double)numberFiles / 36.0);
    }

    public static List<String> getFiles(String path) {
        ArrayList<String> list = new ArrayList<String>();
        String realPath = path + ".";
        for (UHCMessage message : UHCMessageManager.getMessagesByFiles(path)) {
            String key = message.getKey();
            if (!key.contains(".") || path != "" && !key.startsWith(realPath)) continue;
            String diff = key;
            if (path != "") {
                diff = key.replace(realPath, "");
            }
            if (!diff.contains(".")) continue;
            String file = (path == "" ? path : realPath) + diff.split("\\.")[0];
            if (list.contains(file)) continue;
            list.add(file);
        }
        return list;
    }

    public static List<UHCMessage> getFinalMessages(String path) {
        ArrayList<UHCMessage> list = new ArrayList<UHCMessage>();
        String realPath = path + ".";
        for (UHCMessage message : UHCMessageManager.getMessagesByFiles(path)) {
            String key = message.getKey();
            if (!key.contains(".") || path != "" && !key.startsWith(realPath)) continue;
            String diff = key;
            if (path != "") {
                diff = key.replace(realPath, "");
            }
            if (diff.contains(".")) continue;
            list.add(message);
        }
        return list;
    }
}

