/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.langues.msg;

import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessageManager;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.tasks.Timer;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class UHCMessage {
    private String key;
    private HashMap<Langue, String> messages;

    public UHCMessage(String key) {
        this.key = key;
        this.messages = new HashMap();
        for (Langue langue : LangueManager.getLangues()) {
            String msg = "";
            if (langue.getFile().contains(key)) {
                msg = langue.getFile().getString(key);
            } else {
                langue.getFile().setValue(key, msg);
            }
            this.messages.put(langue, msg);
        }
        UHCMessageManager.getMessages().add(this);
    }

    public void reload() {
        this.messages = new HashMap();
        for (Langue langue : LangueManager.getLangues()) {
            String msg = "";
            if (langue.getFile().contains(this.key)) {
                msg = langue.getFile().getString(this.key);
            } else {
                langue.getFile().setValue(this.key, msg);
            }
            this.messages.put(langue, msg);
        }
    }

    public String getKey() {
        return this.key;
    }

    public HashMap<Langue, String> getMessages() {
        return this.messages;
    }

    public String getBrut(Langue langue) {
        if (!this.messages.containsKey(langue)) {
            return "";
        }
        return this.messages.get(langue);
    }

    public String getText(Langue langue, Object ... objects) {
        if (langue == null) {
            langue = LangueManager.getDefaultLangue();
        }
        if (this.messages.get(langue) == null || this.messages.get(langue).equals("")) {
            return "";
        }
        String language = ChatUtil.convertText(this.messages.get(langue));
        for (Timer timer : TimerManager.getTimers()) {
            if (!language.contains("<" + timer.getKey() + ">")) continue;
            language = language.replace("<" + timer.getKey() + ">", ChatUtil.getTime(langue, (Integer)timer.getTime()));
        }
        for (Settings setting : SettingsManager.getSettings()) {
            if (!language.contains("<" + setting.getVariable().getKey() + ">")) continue;
            language = language.replace("<" + setting.getVariable().getKey() + ">", setting.getTextValue(langue));
        }
        int id = 0;
        for (Object object : objects) {
            if (language.contains("<arg" + id + ">")) {
                language = language.replace("<arg" + id + ">", object + "");
            }
            ++id;
        }
        if (this.key.startsWith("ui.title") && language.length() > 32) {
            language = language.substring(0, 32);
        }
        return language;
    }

    public String getText(UHCPlayer up, Object ... objects) {
        return this.getText(up.getLangue(), objects);
    }

    public String getText(Player p, Object ... objects) {
        return this.getText(UHCPlayerManager.getPlayer(p).getLangue(), objects);
    }

    public String getText(ScorpionPlayer sp, Object ... objects) {
        return this.getText(UHCPlayerManager.getPlayer(sp).getLangue(), objects);
    }

    public void send(UHCPlayer up, Object ... objects) {
        if (up == null) {
            return;
        }
        Player p = up.getPlayer();
        if (p == null || !p.isOnline()) {
            return;
        }
        String language = this.getText(up, objects);
        if (language.equals("")) {
            return;
        }
        if (language.contains("{") && language.contains("}")) {
            if (language.contains("{chat:")) {
                String text = language.split("\\{chat:")[1].split("\\}")[0];
                p.sendMessage(text);
            }
            if (language.contains("{title:")) {
                String title = language.split("\\{title:")[1].split(":")[0];
                String subtitle = language.split("\\{title:")[1].split(":")[1].split("\\}")[0];
                up.getScorpionPlayer().getPlayerPacket().sendTitle(title, subtitle, 100);
            }
            if (language.contains("{action:")) {
                String action = language.split("\\{action:")[1].split("\\}")[0];
                up.getScorpionPlayer().getPlayerPacket().sendActionBar(action);
            }
            if (language.contains("{sound:")) {
                String sound = language.split("\\{sound:")[1].split("\\}")[0];
                p.playSound(p.getLocation(), sound, 1.0f, 1.0f);
            }
            return;
        }
        p.sendMessage(language);
    }

    public void sendTo(ScorpionPlayer sp, Object ... objects) {
        if (sp == null) {
            return;
        }
        this.send(UHCPlayerManager.getPlayer(sp), objects);
    }

    public void sendTo(Player p, Object ... objects) {
        if (p == null) {
            return;
        }
        this.send(UHCPlayerManager.getPlayer(p), objects);
    }

    public void sendTeam(UHCTeam team, Object ... objects) {
        if (team == null) {
            return;
        }
        for (UHCPlayer up : team.getPlayers()) {
            if (up.getPlayer() == null || !up.getPlayer().isOnline()) continue;
            this.send(up, objects);
        }
    }

    public void sendDeads(Object ... objects) {
        if (UHCPlayerManager.getAllPlayers() == null) {
            return;
        }
        for (UHCPlayer up : UHCPlayerManager.getAllPlayers()) {
            if (up.isDeconnecting() || up.getPlayer() == null || !up.isDead() && up.isPlaying()) continue;
            this.send(up, objects);
        }
    }

    public void sendAll(Object ... objects) {
        if (UHCPlayerManager.getAllPlayers() == null) {
            return;
        }
        for (UHCPlayer up : UHCPlayerManager.getAllPlayers()) {
            if (up.isDeconnecting() || up.getPlayer() == null) continue;
            this.send(up, objects);
        }
    }

    public void sendStaff(Object ... objects) {
        if (UHCPlayerManager.getAllPlayers() == null) {
            return;
        }
        for (UHCPlayer up : UHCPlayerManager.getAllPlayers()) {
            if (up.isDeconnecting() || up.getPlayer() == null || !Permissions.STAFF_MESSAGE.hasPerm(up.getPlayer())) continue;
            this.send(up, objects);
        }
    }

    public static UHCMessage get(String key) {
        UHCMessage msg = null;
        for (UHCMessage list : UHCMessageManager.getMessages()) {
            if (!list.getKey().equals(key)) continue;
            msg = list;
        }
        return msg;
    }
}

