/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.langues;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessageManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.utils.item.Flags;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LangueManager {
    private static List<Langue> langues;

    public static void loadLangues() {
        List<File> files = LangueManager.getLanguesFiles();
        langues = new ArrayList<Langue>();
        if (files.isEmpty()) {
            new Langue(Flags.FRANCE);
            new Langue(Flags.ENGLAND);
        } else {
            files.forEach(f -> new Langue((File)f));
        }
        UHCMessageManager.loadMessages();
    }

    public static void saveLangues() {
        langues.forEach(langue -> langue.getFile().saveFile());
    }

    public static List<File> getLanguesFiles() {
        List<Object> filesName = new ArrayList();
        if (Files.notExists(Paths.get(UHC.getInstance().getDataFolder() + "/languages", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(Paths.get(UHC.getInstance().getDataFolder() + "/languages", new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (Stream<Path> walk = Files.walk(Paths.get(UHC.getInstance().getDataFolder() + "/languages", new String[0]), new FileVisitOption[0]);){
            filesName = walk.map(x -> x.toString()).filter(f -> f.endsWith(".yml")).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<File>();
        }
        ArrayList<File> files = new ArrayList<File>();
        filesName.forEach(name -> files.add(new File((String)name)));
        return files;
    }

    public static List<Langue> getLangues() {
        return langues;
    }

    public static Langue getLangue(String key) {
        return langues.stream().filter(langue -> langue.getFlag().getKey().equals(key)).findFirst().orElse(null);
    }

    public static Langue getDefaultLangue() {
        return langues.stream().filter(langue -> langue.getFlag().getKey().equals(ConfigFile.LANGUE_DEFAULT.getString())).findFirst().orElse(null);
    }

    public static boolean containsLangue(Flags flag) {
        return langues.stream().anyMatch(langue -> langue.getFlag().equals((Object)flag));
    }
}

