/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.langues;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.utils.item.Flags;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class LangueFile {
    private File file;
    private FileConfiguration configFile;
    private boolean haveGoodFormat;

    public LangueFile(File file) {
        this.file = file;
        this.configFile = YamlConfiguration.loadConfiguration((File)file);
        this.haveGoodFormat = false;
        if (!file.exists()) {
            return;
        }
        if (!this.configFile.isConfigurationSection("options") || !this.configFile.contains("options.flag")) {
            return;
        }
        this.haveGoodFormat = true;
    }

    public LangueFile(Flags flag) {
        this.file = new File(UHC.getInstance().getDataFolder() + "/languages/" + flag.getLowerName() + ".yml");
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.haveGoodFormat = false;
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
                String ressourceName = "languages" + File.separator + flag.getLowerName() + ".yml";
                if (UHC.getInstance().getResource(ressourceName) != null) {
                    UHC.getInstance().saveResource(ressourceName, true);
                    this.reloadFile();
                }
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create " + flag.getLowerName() + ".yml!");
            }
        }
        this.setValue("options.flag", flag.getKey());
        this.haveGoodFormat = true;
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public boolean haveGoodFormat() {
        return this.haveGoodFormat;
    }

    public void setValue(String path, Object object) {
        this.configFile.set(path, object);
    }

    public int getInteger(String path) {
        return this.configFile.getInt(path);
    }

    public String getString(String path) {
        return this.configFile.getString(path);
    }

    public ItemStack getItemStack(String path) {
        return this.configFile.getItemStack(path);
    }

    public boolean contains(String path) {
        return this.configFile.contains(path);
    }

    public void saveFile() {
        try {
            this.configFile.save(this.file);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not save " + this.file.getName() + " !");
        }
    }

    public void reloadFile() {
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.saveFile();
    }
}

