/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.integration.twitter;

import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterManager {
    private final String consumer_key = ConfigFile.TWITTER_CONSUMER_KEY.getRawString();
    private final String consumer_secret = ConfigFile.TWITTER_CONSUMER_SECRET.getRawString();
    private final String token_key = ConfigFile.TWITTER_TOKEN_KEY.getRawString();
    private final String token_secret = ConfigFile.TWITTER_TOKEN_SECRET.getRawString();
    private Twitter twitter = null;
    private long lastId = 0L;

    public void connect() {
        if (!ConfigFile.TWITTER_ENABLE.getBoolean()) {
            return;
        }
        if (this.consumer_key == "" || this.consumer_secret == "" || this.token_key == "" || this.token_secret == "") {
            System.out.println("TWITTER: NOT COMPLETED");
            return;
        }
        try {
            ConfigurationBuilder cb = new ConfigurationBuilder();
            cb.setDebugEnabled(false);
            cb.setOAuthConsumerKey(this.consumer_key);
            cb.setOAuthConsumerSecret(this.consumer_secret);
            cb.setOAuthAccessToken(this.token_key);
            cb.setOAuthAccessTokenSecret(this.token_secret);
            TwitterFactory twitterFactory = new TwitterFactory(cb.build());
            this.twitter = twitterFactory.getInstance();
            System.out.println("TWITTER: Connected with @" + this.twitter.getScreenName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void publishTweet(String tweet, CommandSender sender, boolean isPublishGame) {
        if (!isPublishGame) {
            this.tweet(tweet, sender);
            return;
        }
        this.removeLastTweet();
        this.tweet(tweet, sender);
    }

    public void finishTweet(String tweet, CommandSender sender) {
        System.out.println("TWITTER: Send finish tweet by " + sender.getName());
        if (this.lastId == 0L) {
            try {
                Status status = this.twitter.updateStatus(tweet);
                String url = "https://twitter.com/" + status.getUser().getScreenName() + "/status/" + status.getId();
                this.lastId = status.getId();
                System.out.println("TWITTER: Success finish tweet by " + sender.getName());
                System.out.println(url);
            }
            catch (Exception e) {
                System.out.println("TWITTER: Error finish tweet by " + sender.getName());
                e.printStackTrace();
            }
            return;
        }
        StatusUpdate stat = new StatusUpdate(tweet);
        stat.setInReplyToStatusId(this.lastId);
        try {
            Status status = this.twitter.updateStatus(stat);
            String url = "https://twitter.com/" + status.getUser().getScreenName() + "/status/" + status.getId();
            this.lastId = status.getId();
            System.out.println("TWITTER: Success finish tweet by " + sender.getName());
            System.out.println(url);
        }
        catch (Exception e) {
            System.out.println("TWITTER: Error finish tweet by " + sender.getName());
            e.printStackTrace();
        }
    }

    public Status tweet(String tweet) {
        return this.tweet(tweet, (CommandSender)Bukkit.getConsoleSender());
    }

    public Status tweet(String tweet, CommandSender sender) {
        System.out.println("TWITTER: Send publish tweet by " + sender.getName());
        tweet = ChatColor.stripColor((String)ChatUtil.convertText(tweet));
        try {
            Status status = this.twitter.updateStatus(tweet);
            String url = "https://twitter.com/" + status.getUser().getScreenName() + "/status/" + status.getId();
            if (sender instanceof Player) {
                MEnum.SEND_TWEET.sendTo((Player)sender, status.getText(), this.twitter.getScreenName(), url);
            }
            this.lastId = status.getId();
            System.out.println("TWITTER: Success publish tweet by " + sender.getName());
            System.out.println(url);
            return status;
        }
        catch (Exception e) {
            if (sender instanceof Player) {
                MEnum.ERROR_TWEET.sendTo((Player)sender, new Object[0]);
            }
            System.out.println("TWITTER: Error publish tweet by " + sender.getName());
            e.printStackTrace();
            return null;
        }
    }

    public void removeLastTweet() {
        try {
            this.twitter.destroyStatus(this.lastId);
        }
        catch (TwitterException e) {
            e.printStackTrace();
        }
    }

    public long getLastId() {
        return this.lastId;
    }

    public Twitter getTwitter() {
        return this.twitter;
    }
}

