/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.integration.discord;

import eu.scorpionltd.uhc.manager.integration.discord.DiscordWebhook;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import java.io.IOException;

public class DiscordManager {
    public static void sendMessage(UHCPlayer sender, String content) {
        String discordWebhook = ConfigFile.DISCORD_WEBHOOK.getString();
        if (discordWebhook == "") {
            if (sender != null) {
                MEnum.NO_CONFIG_DISCORD.send(sender, new Object[0]);
            }
            System.out.println("DISCORD: NOT COMPLETED");
            return;
        }
        content = ChatUtil.convertText(content);
        DiscordWebhook webhook = new DiscordWebhook(discordWebhook);
        webhook.setContent(content);
        String avatar = ConfigFile.DISCORD_AVATAR.getString();
        if (avatar != "") {
            webhook.setAvatarUrl(avatar);
        }
        webhook.setUsername(ConfigFile.DISCORD_USERNAME.getString());
        webhook.setTts(false);
        try {
            webhook.execute();
            System.out.println("DISCORD: EXECUTE WEBHOOK - " + content);
            MEnum.SEND_DISCORD.send(sender, new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

