/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.integration;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class OpenTime {
    private static OpenTime instance = null;
    private int hour;
    private int minutes;
    private BukkitTask task;

    public static OpenTime getInstance() {
        return instance;
    }

    public static void resetInstance(OpenTime time) {
        if (instance != null) {
            instance.getTask().cancel();
        }
        instance = time;
    }

    public OpenTime(int hour, int minutes) {
        this.hour = hour;
        this.minutes = minutes;
        ServerUtil.sendStatutChangeEvent();
        this.task = new BukkitRunnable(){

            public void run() {
                String utcTime = ServerUtil.getTimeUTC();
                String[] values = utcTime.split(":");
                if (values[0].equals("" + OpenTime.this.getFormatHour()) && values[1].equals("" + OpenTime.this.getFormatMinutes())) {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "openwl");
                    OpenTime.this.task.cancel();
                }
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), 0L, 5L);
        OpenTime.resetInstance(this);
    }

    public int getHour() {
        return this.hour;
    }

    public String getFormatHour() {
        return (this.hour < 10 ? "0" : "") + this.hour;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public String getFormatMinutes() {
        return (this.minutes < 10 ? "0" : "") + this.minutes;
    }

    public String getText() {
        return ChatColor.AQUA + "" + this.getFormatHour() + ChatColor.GRAY + ":" + ChatColor.AQUA + this.getFormatMinutes();
    }

    public BukkitTask getTask() {
        return this.task;
    }
}

