/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.integration;

import eu.scorpionltd.uhc.manager.integration.discord.DiscordManager;
import eu.scorpionltd.uhc.manager.integration.twitter.TwitterManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class IntegrationManager {
    private static TwitterManager twitterManager = null;
    private static boolean isPublishGame;

    public static void setup() {
        twitterManager = new TwitterManager();
        twitterManager.connect();
        isPublishGame = false;
    }

    public static void publishGame(UHCPlayer player, String moreInfos) {
        String twitterMessage = ConfigFile.TWITTER_PUBLISH_MESSAGE.getString();
        if (ConfigFile.TWITTER_ENABLE.getBoolean() && twitterMessage != "") {
            if (ConfigFile.TWITTER_EXTERNAL_VALUE.getBoolean()) {
                twitterMessage = twitterMessage.replace("<more_infos>", moreInfos);
            }
            twitterManager.publishTweet(twitterMessage, (CommandSender)player.getPlayer(), isPublishGame);
            isPublishGame = true;
        }
        String discordMessage = ConfigFile.DISCORD_PUBLISH_MESSAGE.getString().replace("<more_infos>", moreInfos);
        if (ConfigFile.DISCORD_ENABLE.getBoolean() && discordMessage != "") {
            if (ConfigFile.DISCORD_EXTERNAL_VALUE.getBoolean()) {
                discordMessage = discordMessage.replace("<more_infos>", moreInfos);
            }
            DiscordManager.sendMessage(player, discordMessage);
            isPublishGame = true;
        }
        if (!isPublishGame) {
            MEnum.NO_CONFIG_INTEGRATION.send(player, new Object[0]);
        }
    }

    public static void publishWinners(String winners, int kills) {
        String twitterMessage = ConfigFile.TWITTER_FINISH_MESSAGE.getString();
        if (ConfigFile.TWITTER_ENABLE.getBoolean() && ConfigFile.TWITTER_AUTO_FINISH.getBoolean() && twitterMessage != "") {
            String formattedMessage = ChatUtil.convertText(twitterMessage.replace("<winners>", winners).replace("<kills>", "" + kills));
            twitterManager.finishTweet(formattedMessage, (CommandSender)Bukkit.getConsoleSender());
        }
        String discordMessage = ConfigFile.DISCORD_FINISH_MESSAGE.getString();
        if (ConfigFile.DISCORD_ENABLE.getBoolean() && ConfigFile.DISCORD_AUTO_FINISH.getBoolean() && discordMessage != "") {
            String formattedMessage = ChatUtil.convertText(discordMessage.replace("<winners>", winners).replace("<kills>", "" + kills));
            DiscordManager.sendMessage(null, formattedMessage);
        }
        if (!ConfigFile.TWITTER_AUTO_FINISH.getBoolean() || !ConfigFile.DISCORD_AUTO_FINISH.getBoolean()) {
            MEnum.DO_SCREEN_FINISH.getMessage().sendStaff(new Object[0]);
        }
    }

    public static TwitterManager getTwitterManager() {
        return twitterManager;
    }

    public static boolean isPublishGame() {
        return isPublishGame;
    }
}

