/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.whitelist;

import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistManager;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistTypeFile;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistMode;
import eu.scorpionltd.utils.item.Item;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class WhitelistType {
    private String key;
    private int slot;
    private boolean isDefault;
    private String name;
    private Material material;
    private WhitelistMode mode;
    private String permissionToJoin;
    private String permissionToSwitch;

    public WhitelistType(String key) {
        this.key = key;
        this.slot = 22;
        this.isDefault = false;
        this.name = key;
        this.material = Material.BIRCH_DOOR_ITEM;
        this.mode = WhitelistMode.PUBLIC;
        this.permissionToJoin = "";
        this.permissionToSwitch = "";
        WhitelistManager.getWhitelists().add(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return "types." + this.key;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getRawName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public ItemStack getItemStack() {
        return new Item(this.material, this.getDisplayName()).toItemStackwithItemFlag(ItemFlag.values());
    }

    public WhitelistMode getMode() {
        return this.mode;
    }

    public void setMode(WhitelistMode mode) {
        this.mode = mode;
    }

    public String getPermissionToJoin() {
        return this.permissionToJoin;
    }

    public boolean hasPermissionToJoin(Player player) {
        if (this.permissionToJoin == null || this.permissionToJoin.equals("") || this.permissionToJoin.isEmpty()) {
            return true;
        }
        return player.hasPermission(this.permissionToJoin) || Permissions.JOIN_STAFF.hasPerm(player);
    }

    public void setPermissionToJoin(String permissionToJoin) {
        this.permissionToJoin = permissionToJoin;
    }

    public String getPermissionToSwitch() {
        return this.permissionToSwitch;
    }

    public boolean hasPermissionToSwitch(Player player) {
        if (this.permissionToSwitch == null || this.permissionToSwitch.equals("") || this.permissionToSwitch.isEmpty()) {
            return true;
        }
        return player.hasPermission(this.permissionToSwitch) || Permissions.ADMIN_ACCESS.hasPerm(player);
    }

    public void setPermissionToSwitch(String permissionToSwitch) {
        this.permissionToSwitch = permissionToSwitch;
    }

    public void removeWhitelist() {
        WhitelistManager.getFile().getConfigFile().set(this.getPath(), null);
        WhitelistManager.getWhitelists().remove(this);
    }

    public void loadAll() {
        WhitelistTypeFile file = WhitelistManager.getFile();
        this.slot = file.getInteger(this.getPath() + ".slot");
        this.isDefault = (Boolean)file.getObject(this.getPath() + ".isDefault");
        this.name = file.getString(this.getPath() + ".name");
        this.material = Material.valueOf((String)file.getString(this.getPath() + ".material"));
        this.mode = WhitelistMode.getMode(file.getString(this.getPath() + ".mode"));
        this.permissionToJoin = file.getString(this.getPath() + ".permissionToJoin");
        this.permissionToSwitch = file.getString(this.getPath() + ".permissionToSwitch");
    }

    public void saveAll() {
        WhitelistTypeFile file = WhitelistManager.getFile();
        file.setValue(this.getPath() + ".slot", this.slot);
        file.setValue(this.getPath() + ".isDefault", this.isDefault);
        file.setValue(this.getPath() + ".name", this.name);
        file.setValue(this.getPath() + ".material", this.material.name());
        file.setValue(this.getPath() + ".mode", this.mode.name());
        file.setValue(this.getPath() + ".permissionToJoin", this.permissionToJoin);
        file.setValue(this.getPath() + ".permissionToSwitch", this.permissionToSwitch);
    }
}

