/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.whitelist;

import eu.scorpionltd.uhc.events.custom.server.WhitelistTypeChangeEvent;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistType;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistTypeFile;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.whitelist.WhitelistMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;

public class WhitelistManager {
    private static WhitelistType currentWhitelist;
    private static List<WhitelistType> whitelistsType;
    private static WhitelistTypeFile whitelistTypeFile;

    public static WhitelistType getCurrentWhitelist() {
        return currentWhitelist;
    }

    public static void setCurrentType(WhitelistType type) {
        currentWhitelist = type;
        ServerUtil.sendStatutChangeEvent();
        Bukkit.getPluginManager().callEvent((Event)new WhitelistTypeChangeEvent(type));
    }

    public static void loadWhitelists() {
        whitelistsType = new ArrayList<WhitelistType>();
        whitelistTypeFile = new WhitelistTypeFile();
        if (whitelistTypeFile.getConfigFile().isConfigurationSection("types")) {
            whitelistTypeFile.getConfigFile().getConfigurationSection("types").getKeys(false).forEach(s -> new WhitelistType((String)s).loadAll());
        }
        if (whitelistsType.isEmpty()) {
            WhitelistType prive = new WhitelistType("private");
            prive.setMaterial(Material.REDSTONE_BLOCK);
            prive.setName("&cPriv\u00e9e");
            prive.setSlot(20);
            prive.setMode(WhitelistMode.PRIVATE);
            WhitelistType pvgames = new WhitelistType("pvgames");
            pvgames.setMaterial(Material.GOLD_BLOCK);
            pvgames.setName("&dPVGames");
            pvgames.setSlot(22);
            pvgames.setMode(WhitelistMode.PERMISSION);
            pvgames.setPermissionToJoin(Permissions.JOIN_PVGAMES.getPerm());
            WhitelistType publique = new WhitelistType("publique");
            publique.setDefault(true);
            publique.setMaterial(Material.SLIME_BLOCK);
            publique.setName("&aPublique");
            publique.setSlot(24);
            publique.setMode(WhitelistMode.PUBLIC);
        }
        currentWhitelist = WhitelistManager.getDefaultWhitelist();
    }

    public static void saveWhitelists() {
        Iterator<WhitelistType> i = whitelistsType.iterator();
        while (i.hasNext()) {
            WhitelistType whitelist = i.next();
            whitelist.saveAll();
            i.remove();
        }
        whitelistTypeFile.saveFile();
    }

    public static List<WhitelistType> getWhitelists() {
        return whitelistsType;
    }

    public static int getWhitelistsLines() {
        return Math.max(1, (int)Math.ceil((double)whitelistsType.size() / 9.0));
    }

    public static WhitelistTypeFile getFile() {
        return whitelistTypeFile;
    }

    public static WhitelistType getDefaultWhitelist() {
        return whitelistsType.stream().filter(whitelist -> whitelist.isDefault()).findFirst().orElse(null);
    }

    public static WhitelistType getWhitelist(String key) {
        return whitelistsType.stream().filter(whitelist -> whitelist.getKey().equals(key)).findFirst().orElse(null);
    }

    public static WhitelistType getWhitelist(WhitelistMode mode) {
        return whitelistsType.stream().filter(whitelist -> whitelist.getMode().equals((Object)mode)).findFirst().orElse(null);
    }
}

