/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.rules;

import eu.scorpionltd.uhc.manager.game.rules.Rules;
import eu.scorpionltd.uhc.manager.game.rules.RulesFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class RulesManager {
    private static List<Rules> rules;
    private static RulesFile rulesFile;
    private static int rulesLines;
    private static String rulesPuce;
    private static String rulesSeparator;

    public static void loadRules() {
        rules = new ArrayList<Rules>();
        rulesFile = new RulesFile();
        rulesLines = 6;
        if (rulesFile.getConfigFile().contains("config.lines")) {
            rulesLines = rulesFile.getInteger("config.lines");
        } else {
            rulesFile.setValue("config.lines", rulesLines);
        }
        rulesPuce = " &8<full_square> ";
        if (rulesFile.getConfigFile().contains("config.puce")) {
            rulesPuce = rulesFile.getString("config.puce");
        } else {
            rulesFile.setValue("config.puce", rulesPuce);
        }
        rulesSeparator = "&8: ";
        if (rulesFile.getConfigFile().contains("config.separator")) {
            rulesSeparator = rulesFile.getString("config.separator");
        } else {
            rulesFile.setValue("config.separator", rulesSeparator);
        }
        if (!rulesFile.getConfigFile().isConfigurationSection("rules")) {
            return;
        }
        rulesFile.getConfigFile().getConfigurationSection("rules").getKeys(false).forEach(s -> new Rules(UUID.fromString(s), null));
    }

    public static void saveRules() {
        Iterator<Rules> i = rules.iterator();
        while (i.hasNext()) {
            Rules rule = i.next();
            rule.saveAll();
            i.remove();
        }
        rulesFile.setValue("config.lines", rulesLines);
        rulesFile.setValue("config.puce", rulesPuce);
        rulesFile.setValue("config.separator", rulesSeparator);
        rulesFile.saveFile();
    }

    public static List<Rules> getRules() {
        return rules;
    }

    public static int getRulesLines() {
        return (int)Math.ceil((double)RulesManager.getRules().size() / 9.0);
    }

    public static RulesFile getFile() {
        return rulesFile;
    }

    public static int getNumberLines() {
        return rulesLines;
    }

    public static void setNumberLines(int number) {
        rulesLines = number;
    }

    public static String getRawPuce() {
        return rulesPuce;
    }

    public static String getPuce() {
        return ChatUtil.convertText(rulesPuce);
    }

    public static void setPuce(String message) {
        rulesPuce = message;
    }

    public static String getRawSeparator() {
        return rulesSeparator;
    }

    public static String getSeparator() {
        return ChatUtil.convertText(rulesSeparator);
    }

    public static void setSeparator(String message) {
        rulesSeparator = message;
    }
}

