/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.rules;

import eu.scorpionltd.uhc.manager.game.rules.RulesFile;
import eu.scorpionltd.uhc.manager.game.rules.RulesManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Rules {
    private UUID uuid;
    private String name;
    private ItemStack item;
    private int slot;
    private List<Settings> settings;

    public Rules(UUID uuid, ItemStack item) {
        this.uuid = uuid;
        this.name = "";
        this.settings = new ArrayList<Settings>();
        if (item == null) {
            this.loadAll();
            RulesManager.getRules().add(this);
            return;
        }
        this.item = item;
        this.slot = 1;
        RulesManager.getRules().add(this);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getPath() {
        return "rules." + this.uuid.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemStack getItem() {
        return new Item(this.item).toItemStackwithItemFlag(ItemFlag.values());
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public List<Settings> getSettings() {
        return this.settings;
    }

    public void setSettings(List<Settings> settings) {
        this.settings = settings;
    }

    public void addSettings(Settings setting) {
        this.settings.add(setting);
    }

    public void removeSettings(Settings setting) {
        this.settings.remove(setting);
    }

    public ItemStack getItemStack(ScorpionPlayer player) {
        Item stack = new Item(this.item.clone());
        stack.setLore(new String[]{"", MEnum.CONFIG_CATEGORIE.getText(player, new Object[0])});
        return stack.toItemStackwithItemFlag(ItemFlag.values());
    }

    public void removeRule() {
        RulesManager.getFile().getConfigFile().set(this.getPath(), null);
        RulesManager.getRules().remove(this);
    }

    public void loadAll() {
        RulesFile file = RulesManager.getFile();
        this.name = file.getString(this.getPath() + ".name");
        this.item = file.getItemStack(this.getPath() + ".item");
        this.slot = file.getInteger(this.getPath() + ".slot");
        for (String key : file.getStringList(this.getPath() + ".settings")) {
            Settings setting = SettingsManager.getSettings(key);
            if (setting == null) continue;
            this.addSettings(setting);
        }
    }

    public void saveAll() {
        RulesFile file = RulesManager.getFile();
        file.setValue(this.getPath() + ".name", this.name);
        file.setValue(this.getPath() + ".item", this.item);
        file.setValue(this.getPath() + ".slot", this.slot);
        List keys = this.settings.stream().map(setting -> setting.getVariable().getKey()).collect(Collectors.toList());
        file.setValue(this.getPath() + ".settings", keys);
    }
}

