/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.holograms;

import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.config.PlayerInfos;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.world.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public enum HologramType {
    NONE("Aucun", Material.BARRIER, "None"),
    GLOBAL_WINS("Global Wins", Material.DIAMOND_BLOCK, "&6&lTop 10 - Wins"),
    GLOBAL_KILLS("Global Kills", Material.IRON_SWORD, "&6&lTop 10 - Kills"),
    GLOBAL_DEATHS("Global Deaths", Material.MOSSY_COBBLESTONE, "&6&lTop 10 - Deaths"),
    GLOBAL_DIAMONDS("Global Diamonds", Material.DIAMOND, "&6&lTop 10 - Diamonds"),
    GLOBAL_GOLDS("Global Golds", Material.GOLD_INGOT, "&6&lTop 10 - Golds"),
    GLOBAL_IRONS("Global Irons", Material.IRON_INGOT, "&6&lTop 10 - Irons"),
    GLOBAL_CAVE_TIME("Global Cave Time", Material.IRON_PICKAXE, "&6&lTop 10 - Cave Time"),
    GLOBAL_SPEC_TIME("Global Spec Time", Material.SKULL_ITEM, "&6&lTop 10 - Spec Time"),
    GLOBAL_PLAYED_GAMES("Global Played Games", Material.DARK_OAK_DOOR_ITEM, "&6&lTop 10 - Played Games"),
    GLOBAL_BEST_KILLSTREAK("Global Best Killstreak", Material.DIAMOND_SWORD, "&6&lTop 10 - Best Killstreak"),
    GLOBAL_BEST_LONGSHOT("Global Best Longshot", Material.BOW, "&6&lTop 10 - Best Longshot"),
    FINISH_INFO("Finish Info", Material.GOLD_BLOCK, "&b&lGame Informations"),
    FINISH_KILLS("Finish Kills", Material.GOLD_INGOT, "&b&lTop Kills");

    private Material material;
    private String name;
    private String defaultTitle;

    private HologramType(String name, Material material, String defaultTitle) {
        this.name = name;
        this.material = material;
        this.defaultTitle = defaultTitle;
    }

    public String getName() {
        return this.name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getDefaultTitle() {
        return this.defaultTitle;
    }

    public List<String> getMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(this.defaultTitle.replace('&', '\u00a7'));
        messages.add(ChatUtil.getLine() + ChatUtil.getLine());
        if (this == GLOBAL_WINS) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalWins() - p1.getGlobalWins();
                }
            }).filter(infos -> infos.getGlobalWins() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_KILLS) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalKills() - p1.getGlobalKills();
                }
            }).filter(infos -> infos.getGlobalKills() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_DEATHS) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalDeaths() - p1.getGlobalDeaths();
                }
            }).filter(infos -> infos.getGlobalDeaths() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_DIAMONDS) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalDiamonds() - p1.getGlobalDiamonds();
                }
            }).filter(infos -> infos.getGlobalDiamonds() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_GOLDS) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalGolds() - p1.getGlobalGolds();
                }
            }).filter(infos -> infos.getGlobalGolds() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_IRONS) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalIrons() - p1.getGlobalIrons();
                }
            }).filter(infos -> infos.getGlobalIrons() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_CAVE_TIME) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalCaveTime() - p1.getGlobalCaveTime();
                }
            }).filter(infos -> infos.getGlobalCaveTime() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_SPEC_TIME) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalSpecTime() - p1.getGlobalSpecTime();
                }
            }).filter(infos -> infos.getGlobalSpecTime() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_PLAYED_GAMES) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalGames() - p1.getGlobalGames();
                }
            }).filter(infos -> infos.getGlobalGames() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_BEST_KILLSTREAK) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getGlobalBestKillstreak() - p1.getGlobalBestKillstreak();
                }
            }).filter(infos -> infos.getGlobalBestKillstreak() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == GLOBAL_BEST_LONGSHOT) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return (int)Math.round(p2.getGlobalBestLongshot() - p1.getGlobalBestLongshot());
                }
            }).filter(infos -> infos.getGlobalBestLongshot() > 0.0).limit(10L).collect(Collectors.toList()));
        } else if (this == FINISH_KILLS) {
            this.fillMessages(messages, UHCPlayerManager.getPlayerInfos().stream().sorted(new Comparator<PlayerInfos>(){

                @Override
                public int compare(PlayerInfos p1, PlayerInfos p2) {
                    return p2.getCurrentKills() - p1.getCurrentKills();
                }
            }).filter(infos -> infos.getCurrentKills() > 0).limit(10L).collect(Collectors.toList()));
        } else if (this == FINISH_INFO) {
            // empty if block
        }
        return messages;
    }

    public void fillMessages(List<String> messages, List<PlayerInfos> infos) {
        int i = 1;
        for (PlayerInfos info : infos) {
            String value = ChatColor.GREEN + "";
            if (this == GLOBAL_WINS) {
                value = value + info.getGlobalWins() + " wins";
            } else if (this == GLOBAL_KILLS) {
                value = value + info.getGlobalKills() + " kills";
            } else if (this == GLOBAL_DEATHS) {
                value = value + info.getGlobalDeaths() + " deaths";
            } else if (this == GLOBAL_DIAMONDS) {
                value = value + info.getGlobalDiamonds() + " diamonds";
            } else if (this == GLOBAL_GOLDS) {
                value = value + info.getGlobalGolds() + " golds";
            } else if (this == GLOBAL_IRONS) {
                value = value + info.getGlobalIrons() + " irons";
            } else if (this == GLOBAL_CAVE_TIME) {
                value = value + ChatUtil.getTime(LangueManager.getDefaultLangue(), (Integer)info.getGlobalCaveTime());
            } else if (this == GLOBAL_SPEC_TIME) {
                value = value + ChatUtil.getTime(LangueManager.getDefaultLangue(), (Integer)info.getGlobalSpecTime());
            } else if (this == GLOBAL_PLAYED_GAMES) {
                value = value + info.getGlobalGames() + " games";
            } else if (this == GLOBAL_BEST_KILLSTREAK) {
                value = value + info.getGlobalBestKillstreak() + " kills";
            } else if (this == GLOBAL_BEST_LONGSHOT) {
                value = value + MathUtil.convertDouble(info.getGlobalBestLongshot()) + " blocks";
            } else if (this == FINISH_KILLS) {
                value = value + info.getCurrentKills() + " kills";
            }
            messages.add(ChatColor.YELLOW + "" + i + ChatColor.GRAY + ". " + ChatColor.AQUA + info.getName() + ChatColor.GRAY + " - " + value);
            ++i;
        }
    }

    public HologramType getNextHologramType() {
        int i = 0;
        int index = 0;
        ArrayList<HologramType> hologramTypes = new ArrayList<HologramType>();
        for (HologramType ht : HologramType.values()) {
            if (this == ht) {
                index = i;
            }
            hologramTypes.add(ht);
            ++i;
        }
        if (hologramTypes.size() == index + 1) {
            return (HologramType)((Object)hologramTypes.get(0));
        }
        return (HologramType)((Object)hologramTypes.get(index + 1));
    }

    public HologramType getPreviousHologramType() {
        int i = 0;
        int index = 0;
        ArrayList<HologramType> hologramTypes = new ArrayList<HologramType>();
        for (HologramType ht : HologramType.values()) {
            if (this == ht) {
                index = i;
            }
            hologramTypes.add(ht);
            ++i;
        }
        if (index == 0) {
            return (HologramType)((Object)hologramTypes.get(i));
        }
        return (HologramType)((Object)hologramTypes.get(index - 1));
    }
}

