/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.holograms;

import eu.scorpionltd.uhc.manager.game.holograms.Hologram;
import eu.scorpionltd.uhc.manager.game.holograms.HologramFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

public class HologramManager {
    private static List<Hologram> holograms;
    private static HologramFile hologramFile;

    public static void loadHolograms() {
        holograms = new ArrayList<Hologram>();
        hologramFile = new HologramFile();
        if (!hologramFile.getConfigFile().isConfigurationSection("holograms")) {
            return;
        }
        hologramFile.getConfigFile().getConfigurationSection("holograms").getKeys(false).forEach(s -> new Hologram(UUID.fromString(s), null));
    }

    public static void refreshHolograms() {
        holograms.forEach(hologram -> {
            for (Entity entity : hologram.getLocation().getWorld().getNearbyEntities(hologram.getLocation(), 2.0, 2.0, 2.0)) {
                if (entity == null || !(entity instanceof ArmorStand)) continue;
                entity.remove();
            }
            hologram.spawnHologram();
        });
    }

    public static void saveHolograms() {
        Iterator<Hologram> i = holograms.iterator();
        while (i.hasNext()) {
            Hologram hologram = i.next();
            hologram.saveAll();
            hologram.getHologram().remove();
            i.remove();
        }
        hologramFile.saveFile();
    }

    public static List<Hologram> getHolograms() {
        return holograms;
    }

    public static int getHologramLines() {
        return (int)Math.ceil((double)HologramManager.getHolograms().size() / 9.0);
    }

    public static int getHologramCategories() {
        return (int)Math.ceil((double)HologramManager.getHolograms().size() / 36.0);
    }

    public static HologramFile getFile() {
        return hologramFile;
    }
}

