/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.holograms;

import eu.scorpionltd.uhc.UHC;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class HologramFile {
    private File file = new File(UHC.getInstance().getDataFolder() + "/game/holograms.yml");
    private FileConfiguration configFile = YamlConfiguration.loadConfiguration((File)this.file);

    public HologramFile() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not create holograms.yml!");
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public void setValue(String path, Object object) {
        this.configFile.set(path, object);
    }

    public int getInteger(String path) {
        if (!this.contains(path)) {
            return 0;
        }
        return this.configFile.getInt(path);
    }

    public String getString(String path) {
        return this.configFile.getString(path);
    }

    public boolean contains(String path) {
        return this.configFile.contains(path);
    }

    public void saveFile() {
        try {
            this.configFile.save(this.file);
        }
        catch (IOException e) {
            Bukkit.getServer().getLogger().severe(ChatColor.RED + "Could not save " + this.file.getName() + " !");
        }
    }

    public void reloadFile() {
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
        this.saveFile();
    }
}

