/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game.holograms;

import eu.scorpionltd.uhc.manager.game.holograms.HologramFile;
import eu.scorpionltd.uhc.manager.game.holograms.HologramManager;
import eu.scorpionltd.uhc.manager.game.holograms.HologramType;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.objets.hologram.HologramCreator;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class Hologram {
    private UUID uuid;
    private String title;
    private HologramType type;
    private double x;
    private double y;
    private double z;
    private HologramCreator hologram;

    public Hologram(UUID uuid, Player player) {
        this.uuid = uuid;
        this.type = HologramType.NONE;
        this.title = this.type.getDefaultTitle();
        if (player == null) {
            this.loadAll();
            HologramManager.getHolograms().add(this);
            return;
        }
        this.x = player.getLocation().getX();
        this.y = player.getLocation().getY();
        this.z = player.getLocation().getZ();
        this.hologram = new HologramCreator(this.getLocation(), this.type.getMessages());
        HologramManager.getHolograms().add(this);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getPath() {
        return "holograms." + this.uuid.toString();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public HologramType getType() {
        return this.type;
    }

    public void setType(HologramType type) {
        this.type = type;
        this.title = type.getDefaultTitle();
    }

    public Location getLocation() {
        return new Location(LobbyUtil.getLobbyWorld(), this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.hologram.setLocation(this.getLocation());
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
        this.hologram.setLocation(this.getLocation());
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
        this.hologram.setLocation(this.getLocation());
    }

    public HologramCreator getHologram() {
        return this.hologram;
    }

    public void setHologram(HologramCreator hologram) {
        this.hologram = hologram;
    }

    public ItemStack getItemStack(ScorpionPlayer sp) {
        Item stack = new Item(this.type.getMaterial(), ChatColor.AQUA + this.type.getName());
        stack.setLore(new String[]{"", MEnum.CONFIG_CATEGORIE.getText(sp, new Object[0])});
        return stack.toItemStackwithItemFlag(ItemFlag.values());
    }

    public void spawnHologram() {
        List<String> messages = this.type.getMessages();
        messages.set(0, this.title.replace('&', '\u00a7'));
        this.hologram.setMessages(messages);
    }

    public void removeHologram() {
        this.hologram.remove();
        HologramManager.getFile().getConfigFile().set(this.getPath(), null);
        HologramManager.getHolograms().remove(this);
    }

    public void resetHologram() {
        this.spawnHologram();
    }

    public void loadAll() {
        HologramFile file = HologramManager.getFile();
        this.title = file.getString(this.getPath() + ".title");
        this.type = HologramType.valueOf(file.getString(this.getPath() + ".type"));
        this.x = file.getInteger(this.getPath() + ".x");
        this.y = file.getInteger(this.getPath() + ".y");
        this.z = file.getInteger(this.getPath() + ".z");
        this.hologram = new HologramCreator(this.getLocation(), this.type.getMessages());
    }

    public void saveAll() {
        HologramFile file = HologramManager.getFile();
        file.setValue(this.getPath() + ".title", this.title);
        file.setValue(this.getPath() + ".type", this.type.toString());
        file.setValue(this.getPath() + ".x", this.x);
        file.setValue(this.getPath() + ".y", this.y);
        file.setValue(this.getPath() + ".z", this.z);
    }
}

