/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager.game;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.manager.langues.Langue;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.langues.msg.UHCMessage;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoRulesManager {
    private static int rulesStatut = 0;

    public static void startAutoRules() {
        rulesStatut = 1;
        MEnum.AUTO_RULES_START.sendAll(new Object[0]);
        UHCMessage autoRules = MEnum.AUTO_RULES.getMessage();
        final HashMap<Langue, List<String>> rules = new HashMap<Langue, List<String>>();
        for (Langue langue : LangueManager.getLangues()) {
            String brut = autoRules.getBrut(langue);
            if (brut == "" || brut == null || brut.isEmpty()) continue;
            if (!brut.contains("<retour>")) {
                rules.put(langue, Arrays.asList(autoRules.getText(langue, new Object[0])));
                continue;
            }
            String[] lignes = brut.split("<retour>");
            ArrayList<String> messages = new ArrayList<String>();
            for (int i = 0; i < lignes.length; ++i) {
                String message = ChatUtil.convertText(lignes[i]);
                for (Settings setting : SettingsManager.getSettings()) {
                    if (!message.contains("<" + setting.getVariable().getKey() + ">")) continue;
                    message = message.replace("<" + setting.getVariable().getKey() + ">", setting.getTextValue(langue));
                }
                messages.add(message);
            }
            rules.put(langue, messages);
        }
        int delay = ConfigFile.LOBBY_SPEED_AUTORULES.getInteger();
        new BukkitRunnable(){

            public void run() {
                for (Langue langue : LangueManager.getLangues()) {
                    if (rules.isEmpty()) {
                        this.cancel();
                        MEnum.AUTO_RULES_FINISH.sendAll(new Object[0]);
                        rulesStatut = 2;
                        return;
                    }
                    if (!rules.containsKey(langue) || ((List)rules.get(langue)).isEmpty()) {
                        rules.remove(langue);
                        continue;
                    }
                    List list = (List)rules.get(langue);
                    AutoRulesManager.sendToLangue(langue, (String)list.remove(0));
                }
            }
        }.runTaskTimer((Plugin)UHC.getInstance(), (long)delay, (long)delay);
    }

    private static void sendToLangue(Langue langue, String message) {
        for (UHCPlayer player : UHCPlayerManager.getOnlineUHCPlayers()) {
            if (player.getInfos().getLangue() != langue) continue;
            player.getPlayer().sendMessage(message);
        }
    }

    public static boolean isProgressing() {
        return rulesStatut == 1;
    }

    public static boolean isFinish() {
        return rulesStatut == 2;
    }
}

