/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.manager;

import eu.scorpionltd.uhc.UHC;
import eu.scorpionltd.uhc.events.EventRegister;
import eu.scorpionltd.uhc.manager.game.CustomCraftManager;
import eu.scorpionltd.uhc.manager.game.DropManager;
import eu.scorpionltd.uhc.manager.game.holograms.HologramManager;
import eu.scorpionltd.uhc.manager.game.rules.RulesManager;
import eu.scorpionltd.uhc.manager.game.whitelist.WhitelistManager;
import eu.scorpionltd.uhc.manager.integration.IntegrationManager;
import eu.scorpionltd.uhc.manager.langues.LangueManager;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.modules.ModuleManager;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.PermissionManager;
import eu.scorpionltd.uhc.manager.players.stats.StatsManager;
import eu.scorpionltd.uhc.manager.scenarios.ScenarioManager;
import eu.scorpionltd.uhc.manager.settings.Settings;
import eu.scorpionltd.uhc.manager.settings.SettingsManager;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.manager.settings.database.DatabaseManager;
import eu.scorpionltd.uhc.manager.settings.limits.LimitsManager;
import eu.scorpionltd.uhc.manager.settings.templates.TemplateManager;
import eu.scorpionltd.uhc.manager.settings.values.ValueCategorie;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.manager.teams.UHCTeamManager;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.manager.world.schematics.SchematicsManager;
import eu.scorpionltd.uhc.scoreboard.ScoreboardLife;
import eu.scorpionltd.uhc.scoreboard.TabManager;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.tasks.runnable.CooldownTask;
import eu.scorpionltd.uhc.tasks.runnable.GameTimer;
import eu.scorpionltd.uhc.tasks.runnable.TeleportationTask;
import eu.scorpionltd.uhc.util.player.InventoryUtil;
import eu.scorpionltd.uhc.util.player.MovementUtil;
import eu.scorpionltd.uhc.util.server.PacketUtil;
import eu.scorpionltd.uhc.util.server.ServerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import eu.scorpionltd.uhc.util.world.border.BorderUtil;
import eu.scorpionltd.uhc.util.world.monde.ArenaUtil;
import eu.scorpionltd.utils.RankUtils;
import eu.scorpionltd.utils.task.Cooldown;
import eu.scorpionltd.utils.variable.list.VariableList;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GameManager {
    public static void setupHost() {
        GameWorldManager.initGameWorlds();
        SchematicsManager.loadSchematics();
        EventRegister.registerLobbyEvents(UHC.getInstance());
        LangueManager.loadLangues();
        DatabaseManager.loadDatabase();
        PermissionManager.loadPermissions();
        WhitelistManager.loadWhitelists();
        UHCPlayerManager.loadPlayers();
        TemplateManager.loadTemplates();
        ScenarioManager.loadScenarios();
        ModuleManager.loadModules();
        ModuleManager.missingModules();
        LangueManager.saveLangues();
        TemplateManager.saveTemplates();
        ServerUtil.setupWhitelist();
        TabManager.setupTab();
        UHCTeamManager.resetInstance();
        ServerUtil.setupBungeeCordChannel((Plugin)UHC.getInstance());
        IntegrationManager.setup();
        HologramManager.loadHolograms();
        RulesManager.loadRules();
        LimitsManager.loadLimits();
        Status.setCurrentStatus(Status.WAITING);
    }

    public static void startCooldown() {
        if (Status.getCurrentStatus() != Status.WAITING) {
            return;
        }
        Status.setCurrentStatus(Status.COOLDOWN);
        for (UHCPlayer players : UHCPlayerManager.getOnlineUHCPlayers()) {
            if (!players.isBypassMode()) continue;
            players.inverseBypassMode();
        }
        if (!Values.CHAT_SEE_GAME_RANKS.getBoolean()) {
            RankUtils.setLinkTab((boolean)false);
        }
        ScoreboardLife.setup();
        TimerManager.registerTimers();
        BorderUtil.createBorders();
        UHC.getTeamManager().generateTeams();
        new CooldownTask();
    }

    public static void finishCooldown(HashMap<UHCPlayer, Location> locations) {
        ArrayList<UHCPlayer> players = new ArrayList<UHCPlayer>(UHCPlayerManager.getPlayings());
        new TeleportationTask(locations, () -> {
            Bukkit.getWhitelistedPlayers().forEach(player -> player.setWhitelisted(false));
            Bukkit.getOnlinePlayers().forEach(player -> {
                player.setWhitelisted(true);
                if (!UHCPlayerManager.getPlayer(player).isPlaying()) {
                    Player staff = player.getPlayer();
                    staff.setGameMode(GameMode.SPECTATOR);
                    staff.teleport(new Location(ArenaUtil.getArenaWorld(), 0.5, 150.0, 0.5));
                }
            });
            int i = 0;
            boolean isMysteryTeam = Values.TEAM_MYSTERY_TEAM.getBoolean();
            if (isMysteryTeam) {
                int bannerType = Values.TEAM_BANNER_TYPE.getInteger();
                if (bannerType == 1) {
                    Values.INVENTORY_NO_DROP.getSettings().addItemStack(null, new ItemStack(Material.BANNER, 1));
                } else if (bannerType == 2) {
                    Values.INVENTORY_NO_DROP.getSettings().addItemStack(null, new ItemStack(Material.FIREWORK, 1));
                }
            }
            int bannerTime = Values.TEAM_BANNER_TIME.getInteger();
            for (UHCPlayer player2 : players) {
                Player p = player2.getPlayer();
                if (p == null) continue;
                try {
                    p.setMaxHealth(20.0);
                    p.setHealth(20.0);
                    p.setGameMode(GameMode.SURVIVAL);
                    p.getInventory().clear();
                    Values.INVENTORY_START.getListItemStack().forEach(item -> InventoryUtil.addItem(p, item));
                    if (player2.getModifiers().getGiveDiamondPickaxe() == 1) {
                        ItemStack pickaxe = new ItemStack(Material.DIAMOND_PICKAXE, 1);
                        pickaxe.addEnchantment(Enchantment.DIG_SPEED, 4);
                        InventoryUtil.addItem(p, pickaxe);
                    }
                    p.setWalkSpeed(0.2f);
                    p.setFoodLevel(20);
                    ScoreboardLife.updateHealth(p);
                    MovementUtil.unfreeze(p);
                    PacketUtil.changeCoords(p);
                    UHCTeam team = UHC.getTeam(player2);
                    if (team != null && isMysteryTeam && bannerTime == 0) {
                        team.giveTeamItem(p);
                    }
                    if (i >= 10) continue;
                    UHC.getScoreboard().getClassement()[i] = player2.getUUID();
                    ++i;
                }
                catch (Exception e) {
                    System.out.println("(SupUHC) TP: Erreur dans la teleportation du joueur " + player2.getName());
                }
            }
            GameManager.startGame();
            MEnum.GAME_START.sendAll(new Object[0]);
        });
    }

    public static void startGame() {
        Status.setCurrentStatus(Status.IN_GAME);
        EventRegister.registerGameEvents(UHC.getInstance());
        BorderUtil.setupBorderSystem();
        TimerManager.setupGame();
        new GameTimer();
        UHC.getScoreboard().switchScoreboard();
        CustomCraftManager.registerAll();
        DropManager.startDrops();
        StatsManager.startStats();
        ScenarioManager.startScenarios();
    }

    public static void finishGame() {
        Status.setCurrentStatus(Status.FINISH);
        EventRegister.unregisterGameEvents();
        if (ConfigFile.FINISH_TP_ENABLE.getBoolean()) {
            Location loc = ConfigFile.FINISH_TP_LOCATION.getLocation();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.teleport(loc);
            }
        }
        new Cooldown(1){

            public void onFinish() {
                HologramManager.refreshHolograms();
            }
        };
        ServerUtil.sendStopRequest();
    }

    public static void resetGame() {
        Status.setCurrentStatus(Status.RESTART);
        ScoreboardLife.unregister();
        PermissionManager.savePermissions();
        HologramManager.saveHolograms();
        RulesManager.saveRules();
        LimitsManager.saveLimits();
        WhitelistManager.saveWhitelists();
        LangueManager.saveLangues();
        UHCPlayerManager.savePlayers();
        ModuleManager.unloadModules();
        for (Settings param : SettingsManager.getSettings(ValueCategorie.INVENTORY)) {
            if (!(param.getVariable() instanceof VariableList)) continue;
            VariableList var = (VariableList)param.getVariable();
            var.setList(new ArrayList());
        }
        TemplateManager.saveTemplates();
        ConfigFile.saveAll(UHC.getInstance());
        DatabaseManager.disableDatabase();
        GameWorldManager.resetGameWorlds();
    }
}

