/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation.worldborder;

import eu.scorpionltd.uhc.events.custom.world.ChunkPregenEvent;
import eu.scorpionltd.uhc.generation.GenerationManager;
import eu.scorpionltd.uhc.generation.worldborder.BorderData;
import eu.scorpionltd.uhc.generation.worldborder.CoordXZ;
import eu.scorpionltd.uhc.generation.worldborder.WorldFileData;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorld;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;

public class WorldFillTask
implements Runnable {
    private Server server;
    private final GameWorld gameWorld;
    private final World world;
    private final BorderData border;
    private final WorldFileData worldData;
    private boolean readyToGo = false;
    private boolean paused = false;
    private boolean pausedForMemory = false;
    private int taskID = -1;
    private final int chunksPerRun;
    private long startTime;
    private int x = 0;
    private int z = 0;
    private boolean isZLeg = false;
    private boolean isNeg = false;
    private int length = -1;
    private int current = 0;
    private boolean insideBorder = true;
    private final List<CoordXZ> storedChunks = new LinkedList<CoordXZ>();
    private final Set<CoordXZ> originalChunks = new HashSet<CoordXZ>();
    private final CoordXZ lastChunk = new CoordXZ(0, 0);
    private long lastReport = System.currentTimeMillis();
    private long lastAutosave = System.currentTimeMillis();
    private int reportTarget = 0;
    private int reportTotal = 0;
    private int reportNum = 0;
    private boolean finish = false;
    private final boolean isPigReplaced;
    private final boolean isSheepReplaced;

    public WorldFillTask(GameWorld gameWorld, int chunksPerRun, int radius) {
        Chunk[] originals;
        this.startTime = System.currentTimeMillis();
        this.server = Bukkit.getServer();
        this.chunksPerRun = chunksPerRun;
        this.gameWorld = gameWorld;
        this.world = gameWorld.getWorld();
        this.isPigReplaced = Values.ENTITY_PIG_REPLACE.getBoolean();
        this.isSheepReplaced = Values.ENTITY_SHEEP_REPLACE.getBoolean();
        int centerX = gameWorld.haveCustomPregenSize() ? 0 : Values.BORDER_CENTER_X.getInteger();
        int centerZ = gameWorld.haveCustomPregenSize() ? 0 : Values.BORDER_CENTER_Z.getInteger();
        this.border = new BorderData(centerX, centerZ, radius, radius);
        this.worldData = WorldFileData.create(this.world);
        if (this.worldData == null) {
            this.stop();
            return;
        }
        this.x = CoordXZ.blockToChunk((int)this.border.getX());
        this.z = CoordXZ.blockToChunk((int)this.border.getZ());
        int chunkWidthX = (int)Math.ceil((double)((this.border.getRadiusX() + 16) * 2) / 16.0);
        int chunkWidthZ = (int)Math.ceil((double)((this.border.getRadiusZ() + 16) * 2) / 16.0);
        int biggerWidth = Math.max(chunkWidthX, chunkWidthZ);
        this.reportTarget = biggerWidth * biggerWidth + biggerWidth + 1;
        for (Chunk original : originals = this.world.getLoadedChunks()) {
            this.originalChunks.add(new CoordXZ(original.getX(), original.getZ()));
        }
        this.readyToGo = true;
        MEnum.START_PREGEN.sendAll(gameWorld.getColorName());
        GenerationManager.getWorldsPregen().add(this.world);
    }

    public void setTaskID(int ID) {
        if (ID == -1) {
            this.stop();
        }
        this.taskID = ID;
    }

    @Override
    public void run() {
        if (this.pausedForMemory) {
            System.out.println("PREGENERATION: Paused for memory");
            if (this.AvailableMemoryTooLow()) {
                System.out.println("PREGENERATION: Memory too low");
                return;
            }
            this.pausedForMemory = false;
            this.readyToGo = true;
        }
        if (this.server == null || !this.readyToGo || this.paused) {
            return;
        }
        this.readyToGo = false;
        long loopStartTime = System.currentTimeMillis();
        for (int loop = 0; loop < this.chunksPerRun; ++loop) {
            int popX;
            if (this.paused || this.pausedForMemory) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now > this.lastReport + 5000L) {
                this.reportProgress();
            }
            if (now > loopStartTime + 45L) {
                this.readyToGo = true;
                return;
            }
            while (!this.border.insideBorder(CoordXZ.chunkToBlock(this.x) + 8, CoordXZ.chunkToBlock(this.z) + 8)) {
                if (!this.cannotMoveToNext()) continue;
                return;
            }
            this.insideBorder = true;
            while (this.worldData.isChunkFullyGenerated(this.x, this.z)) {
                this.insideBorder = true;
                if (!this.cannotMoveToNext()) continue;
                return;
            }
            this.world.loadChunk(this.x, this.z, true);
            Chunk chunk = this.world.getChunkAt(this.x, this.z);
            if (WorldUtil.getEnv(this.world) == World.Environment.NORMAL) {
                this.checkPigReplaced(chunk);
                this.checkSheepReplaced(chunk);
            }
            Bukkit.getPluginManager().callEvent((Event)new ChunkPregenEvent(chunk));
            this.worldData.chunkExistsNow(this.x, this.z);
            int n = !this.isZLeg ? this.x : (popX = this.x + (this.isNeg ? -1 : 1));
            int popZ = this.isZLeg ? this.z : this.z + (!this.isNeg ? -1 : 1);
            this.world.loadChunk(popX, popZ, false);
            Bukkit.getPluginManager().callEvent((Event)new ChunkPregenEvent(this.world.getChunkAt(popX, popZ)));
            if (!this.storedChunks.contains(this.lastChunk) && !this.originalChunks.contains(this.lastChunk)) {
                this.world.loadChunk(this.lastChunk.x, this.lastChunk.z, false);
                Bukkit.getPluginManager().callEvent((Event)new ChunkPregenEvent(this.world.getChunkAt(this.lastChunk.x, this.lastChunk.z)));
                this.storedChunks.add(new CoordXZ(this.lastChunk.x, this.lastChunk.z));
            }
            this.storedChunks.add(new CoordXZ(popX, popZ));
            this.storedChunks.add(new CoordXZ(this.x, this.z));
            while (this.storedChunks.size() > 8) {
                CoordXZ cord = this.storedChunks.remove(0);
                if (this.originalChunks.contains(cord)) continue;
                this.world.unloadChunkRequest(cord.x, cord.z);
            }
            if (!this.cannotMoveToNext()) continue;
            return;
        }
        this.readyToGo = true;
    }

    public boolean cannotMoveToNext() {
        if (this.paused || this.pausedForMemory) {
            return true;
        }
        ++this.reportNum;
        if (this.current < this.length) {
            ++this.current;
        } else {
            this.current = 0;
            this.isZLeg ^= true;
            if (this.isZLeg) {
                this.isNeg ^= true;
                ++this.length;
            }
        }
        this.lastChunk.x = this.x;
        this.lastChunk.z = this.z;
        if (this.isZLeg) {
            this.z += this.isNeg ? -1 : 1;
        } else {
            this.x += this.isNeg ? -1 : 1;
        }
        if (this.isZLeg && this.isNeg && this.current == 0) {
            if (!this.insideBorder) {
                this.finish();
                return true;
            }
            this.insideBorder = false;
        }
        return false;
    }

    public void finish() {
        this.paused = true;
        this.finish = true;
        this.reportProgress();
        this.world.save();
        this.stop();
    }

    public void stop() {
        int calculedTime = Math.round((System.currentTimeMillis() - this.startTime) / 1000L);
        if (this.server == null) {
            return;
        }
        this.readyToGo = false;
        if (this.taskID != -1) {
            this.server.getScheduler().cancelTask(this.taskID);
        }
        this.server = null;
        MEnum.FINISH_PREGEN.sendAll(this.gameWorld.getColorName(), calculedTime);
        while (!this.storedChunks.isEmpty()) {
            CoordXZ cord = this.storedChunks.remove(0);
            if (this.originalChunks.contains(cord)) continue;
            this.world.unloadChunkRequest(cord.x, cord.z);
        }
        System.gc();
        GenerationManager.pregenNextWorld();
    }

    private void reportProgress() {
        this.lastReport = System.currentTimeMillis();
        double percentage = this.getPercentageCompleted();
        if (percentage > 100.0) {
            percentage = 100.0;
        }
        this.sendMessage(MEnum.COOLDOWN_PREGEN, (int)percentage);
        this.reportTotal += this.reportNum;
        this.reportNum = 0;
        int fillAutoSaveFrequency = 30;
        if (this.lastAutosave + (long)(fillAutoSaveFrequency * 1000) < this.lastReport) {
            this.lastAutosave = this.lastReport;
            this.sendMessage(MEnum.COOLDOWN_PREGEN, (int)percentage);
        }
    }

    private void sendMessage(MEnum mEnum, int percentage) {
        int availMem = this.AvailableMemory();
        mEnum.sendAll(this.gameWorld.getColorName(), percentage);
        if (availMem < 200) {
            this.pausedForMemory = true;
            System.gc();
        }
    }

    public String refWorld() {
        return this.world.getName();
    }

    public double getPercentageCompleted() {
        if (this.finish) {
            return 100.0;
        }
        double percentage = Math.min(100.0, (double)(this.reportTotal + this.reportNum) / (double)this.reportTarget * 100.0);
        this.sendMessage(MEnum.COOLDOWN_PREGEN, (int)percentage);
        return percentage;
    }

    public int AvailableMemory() {
        Runtime rt = Runtime.getRuntime();
        return (int)((rt.maxMemory() - rt.totalMemory() + rt.freeMemory()) / 0x100000L);
    }

    public boolean AvailableMemoryTooLow() {
        return this.AvailableMemory() < 500;
    }

    private void checkPigReplaced(Chunk chunk) {
        if (!this.isPigReplaced) {
            return;
        }
        for (Entity entity : chunk.getEntities()) {
            if (entity == null || entity.getType() == null || entity.getType() != EntityType.PIG) continue;
            Location loc = entity.getLocation();
            entity.remove();
            loc.getWorld().spawnEntity(loc, EntityType.COW);
        }
    }

    private void checkSheepReplaced(Chunk chunk) {
        if (!this.isSheepReplaced) {
            return;
        }
        for (Entity entity : chunk.getEntities()) {
            if (entity == null || entity.getType() == null || entity.getType() != EntityType.SHEEP) continue;
            Location loc = entity.getLocation();
            entity.remove();
            loc.getWorld().spawnEntity(loc, EntityType.COW);
        }
    }
}

