/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation.worldborder;

import eu.scorpionltd.uhc.generation.worldborder.CoordXZ;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.World;

public class WorldFileData {
    private final World world;
    private File regionFolder = null;
    private File[] regionFiles = null;
    private final Map<CoordXZ, List<Boolean>> regionChunkExistence = Collections.synchronizedMap(new HashMap());

    public static WorldFileData create(World world) {
        WorldFileData newData = new WorldFileData(world);
        newData.regionFolder = new File(newData.world.getWorldFolder(), "region");
        if (!newData.regionFolder.exists() || !newData.regionFolder.isDirectory()) {
            File[] possibleDimFolders = newData.world.getWorldFolder().listFiles(new DimFolderFileFilter());
            for (File possibleDimFolder : Objects.requireNonNull(possibleDimFolders)) {
                File possible = new File(newData.world.getWorldFolder(), possibleDimFolder.getName() + File.separator + "region");
                if (!possible.exists() || !possible.isDirectory()) continue;
                newData.regionFolder = possible;
                break;
            }
            if (!newData.regionFolder.exists() || !newData.regionFolder.isDirectory()) {
                newData.sendMessage("Could not validate folder for world's region files. Looked in " + newData.world.getWorldFolder().getPath() + " for valid DIM* folder with a region folder in it.");
                return null;
            }
        }
        newData.regionFiles = newData.regionFolder.listFiles(new ExtFileFilter(".MCA"));
        if (newData.regionFiles == null || newData.regionFiles.length == 0) {
            newData.regionFiles = newData.regionFolder.listFiles(new ExtFileFilter(".MCR"));
            if (newData.regionFiles == null || newData.regionFiles.length == 0) {
                newData.sendMessage("Could not find any region files. Looked in: " + newData.regionFolder.getPath());
                return null;
            }
        }
        return newData;
    }

    private WorldFileData(World world) {
        this.world = world;
    }

    public File regionFile(int index) {
        if (this.regionFiles.length < index) {
            return null;
        }
        return this.regionFiles[index];
    }

    public CoordXZ regionFileCoordinates(int index) {
        File regionFile = this.regionFile(index);
        String[] cords = regionFile.getName().split("\\.");
        try {
            int x = Integer.parseInt(cords[1]);
            int z = Integer.parseInt(cords[2]);
            return new CoordXZ(x, z);
        }
        catch (Exception ex) {
            this.sendMessage("Error! Region file found with abnormal name: " + regionFile.getName());
            return null;
        }
    }

    public boolean doesChunkNotExist(int x, int z) {
        CoordXZ region = new CoordXZ(CoordXZ.chunkToRegion(x), CoordXZ.chunkToRegion(z));
        List<Boolean> regionChunks = this.getRegionData(region);
        return regionChunks.get(this.coordToRegionOffset(x, z)) == false;
    }

    public boolean isChunkFullyGenerated(int x, int z) {
        return !this.doesChunkNotExist(x, z) && !this.doesChunkNotExist(x + 1, z) && !this.doesChunkNotExist(x - 1, z) && !this.doesChunkNotExist(x, z + 1) && !this.doesChunkNotExist(x, z - 1);
    }

    public void chunkExistsNow(int x, int z) {
        CoordXZ region = new CoordXZ(CoordXZ.chunkToRegion(x), CoordXZ.chunkToRegion(z));
        List<Boolean> regionChunks = this.getRegionData(region);
        regionChunks.set(this.coordToRegionOffset(x, z), true);
    }

    private int coordToRegionOffset(int x, int z) {
        z %= 32;
        if ((x %= 32) < 0) {
            x += 32;
        }
        if (z < 0) {
            z += 32;
        }
        return x + z * 32;
    }

    private List<Boolean> getRegionData(CoordXZ region) {
        int i;
        List<Boolean> data = this.regionChunkExistence.get(region);
        if (data != null) {
            return data;
        }
        data = new ArrayList<Boolean>(1024);
        for (i = 0; i < 1024; ++i) {
            data.add(Boolean.FALSE);
        }
        for (i = 0; i < this.regionFiles.length; ++i) {
            CoordXZ coord = this.regionFileCoordinates(i);
            if (!coord.equals(region)) continue;
            try {
                RandomAccessFile regionData = new RandomAccessFile(this.regionFile(i), "r");
                for (int j = 0; j < 1024; ++j) {
                    if (regionData.readInt() == 0) continue;
                    data.set(j, true);
                }
                regionData.close();
                continue;
            }
            catch (FileNotFoundException ex) {
                this.sendMessage("Error! Could not open region file to find generated chunks: " + this.regionFile(i).getName());
                continue;
            }
            catch (IOException ex) {
                this.sendMessage("Error! Could not read region file to find generated chunks: " + this.regionFile(i).getName());
            }
        }
        this.regionChunkExistence.put(region, data);
        return data;
    }

    private void sendMessage(String text) {
        System.out.println("[WorldData] " + text);
    }

    private static class ExtFileFilter
    implements FileFilter {
        final String ext;

        public ExtFileFilter(String extension) {
            this.ext = extension.toLowerCase();
        }

        @Override
        public boolean accept(File file) {
            return file.exists() && file.isFile() && file.getName().toLowerCase().endsWith(this.ext);
        }
    }

    private static class DimFolderFileFilter
    implements FileFilter {
        private DimFolderFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.exists() && file.isDirectory() && file.getName().toLowerCase().startsWith("dim");
        }
    }
}

