/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation.worldborder;

import java.text.DecimalFormat;

public class BorderData {
    private final double x;
    private final double z;
    private int radiusX = 0;
    private int radiusZ = 0;
    private double maxX;
    private double minX;
    private double maxZ;
    private double minZ;

    public BorderData(double x, double z, int radiusX, int radiusZ) {
        this.x = x;
        this.z = z;
        this.setRadiusX(radiusX);
        this.setRadiusZ(radiusZ);
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusZ() {
        return this.radiusZ;
    }

    public void setRadiusX(int radiusX) {
        this.radiusX = radiusX;
        this.maxX = this.x + (double)radiusX;
        this.minX = this.x - (double)radiusX;
    }

    public void setRadiusZ(int radiusZ) {
        this.radiusZ = radiusZ;
        this.maxZ = this.z + (double)radiusZ;
        this.minZ = this.z - (double)radiusZ;
    }

    public String toString() {
        return "radius " + (this.radiusX == this.radiusZ ? Integer.valueOf(this.radiusX) : this.radiusX + "x" + this.radiusZ) + " at X: " + new DecimalFormat("0.0").format(this.x) + " Z: " + new DecimalFormat("0.0").format(this.z);
    }

    public boolean insideBorder(double xLoc, double zLoc) {
        return !(xLoc < this.minX || xLoc > this.maxX || zLoc < this.minZ || zLoc > this.maxZ);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BorderData test = (BorderData)obj;
        return test.x == this.x && test.z == this.z && test.radiusX == this.radiusX && test.radiusZ == this.radiusZ;
    }

    public int hashCode() {
        return ((int)(this.x * 10.0) << 4) + (int)this.z + (this.radiusX << 2) + (this.radiusZ << 3);
    }
}

