/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation.event;

import eu.scorpionltd.uhc.events.custom.world.ChunkPregenEvent;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.manager.world.GameWorldManager;
import eu.scorpionltd.uhc.util.server.enums.Metadata;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class XrayEvent
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getBlock() == null || e.getBlock().getLocation().getY() > 33.0) {
            return;
        }
        this.updateBlocks(e.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockDamage(BlockDamageEvent e) {
        if (e.getBlock() == null || e.getBlock().getLocation().getY() > 33.0) {
            return;
        }
        this.updateBlocks(e.getBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockExplose(BlockExplodeEvent e) {
        if (e.getBlock() == null || e.getBlock().getLocation().getY() > 40.0) {
            return;
        }
        for (Block block : e.blockList()) {
            this.updateBlocks(block);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent e) {
        if (e.getEntity() == null || e.getEntity().getLocation().getY() > 40.0) {
            return;
        }
        for (Block block : e.blockList()) {
            this.updateBlocks(block);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockPhysics(BlockPhysicsEvent e) {
        if (e.getBlock() == null || e.getBlock().getLocation().getY() > 33.0) {
            return;
        }
        if (e.getBlock().getType() != Material.SAND && e.getBlock().getType() != Material.GRAVEL) {
            return;
        }
        if (!this.applyPhysics(e.getBlock())) {
            return;
        }
        this.updateBlocks(e.getBlock());
    }

    @EventHandler
    public void onChunkEvent(ChunkPregenEvent e) {
        if (e.getChunk() == null || !GameWorldManager.getGameWorld(e.getChunk().getWorld()).isGameWorld()) {
            return;
        }
        Chunk chunk = e.getChunk();
        int chunkX = chunk.getX() * 16;
        int chunkZ = chunk.getZ() * 16;
        int borderSize = Values.BORDER_SIZE_INIT.getInteger();
        if (chunkX > -borderSize && chunkX < borderSize && chunkZ > -borderSize && chunkZ < borderSize) {
            for (int x = chunk.getX(); x < chunk.getX() + 16; ++x) {
                for (int z = chunk.getZ(); z < chunk.getZ() + 16; ++z) {
                    for (int y = 0; y < 31; ++y) {
                        this.checkXrayOre(chunk.getBlock(x, y, z));
                    }
                }
            }
        }
    }

    private void checkXrayOre(Block block) {
        if (block == null || block.getType() == null || block.getType() == Material.AIR || !this.isFilled(block)) {
            return;
        }
        if (block.getType() == Material.GOLD_ORE) {
            Metadata.HIDE_GOLD.add(block);
            block.setType(Material.STONE);
            return;
        }
        if (block.getType() == Material.DIAMOND_ORE) {
            Metadata.HIDE_DIAMOND.add(block);
            block.setType(Material.STONE);
            return;
        }
        if (block.getType() == Material.EMERALD_ORE) {
            Metadata.HIDE_EMERALD.add(block);
            block.setType(Material.STONE);
            return;
        }
    }

    private final List<BlockFace> getFaces() {
        return Arrays.asList(BlockFace.DOWN, BlockFace.UP, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST);
    }

    private boolean isFilled(Block b) {
        for (BlockFace face : this.getFaces()) {
            Block relative = b.getRelative(face);
            if (relative != null && !relative.isEmpty() && !relative.isLiquid()) continue;
            return false;
        }
        return true;
    }

    private void updateBlocks(Block b) {
        if (Metadata.CHECKED_BLOCKS.has(b)) {
            return;
        }
        Metadata.CHECKED_BLOCKS.add(b);
        for (BlockFace face : this.getFaces()) {
            Block relative = b.getRelative(face);
            if (relative == null || relative.getType() == null || relative.getType() == Material.AIR) continue;
            if (Metadata.HIDE_GOLD.has(relative)) {
                Metadata.HIDE_GOLD.remove(relative);
                relative.setType(Material.GOLD_ORE);
                continue;
            }
            if (Metadata.HIDE_DIAMOND.has(relative)) {
                Metadata.HIDE_DIAMOND.remove(relative);
                relative.setType(Material.DIAMOND_ORE);
                continue;
            }
            if (!Metadata.HIDE_EMERALD.has(relative)) continue;
            Metadata.HIDE_EMERALD.remove(relative);
            relative.setType(Material.EMERALD_ORE);
        }
    }

    private boolean applyPhysics(Block block) {
        Block relative = block.getRelative(0, -1, 0);
        if (relative == null || relative.getType() == null) {
            return true;
        }
        Material type = relative.getType();
        return type == Material.AIR || type == Material.FIRE || type == Material.WATER || type == Material.STATIONARY_WATER || type == Material.LAVA || type == Material.STATIONARY_LAVA;
    }
}

