/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.generation.event;

import eu.scorpionltd.uhc.events.custom.player.game.GameStartEvent;
import eu.scorpionltd.uhc.generation.GenerationManager;
import eu.scorpionltd.uhc.manager.settings.values.Values;
import eu.scorpionltd.uhc.util.server.enums.Pregen;
import eu.scorpionltd.uhc.util.world.BlockUtil;
import eu.scorpionltd.uhc.util.world.WorldUtil;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;

public class GenerationEvent
implements Listener {
    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent e) {
        if (Pregen.getCurrentPregen() == Pregen.PROGRESS && GenerationManager.getWorldsPregen().contains(e.getBlock().getWorld())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockFrom(BlockFromToEvent e) {
        if (Pregen.getCurrentPregen() == Pregen.PROGRESS && GenerationManager.getWorldsPregen().contains(e.getBlock().getWorld())) {
            Block b = e.getBlock();
            if (WorldUtil.getEnv(e.getBlock().getLocation()) != World.Environment.THE_END && BlockUtil.isLiquid(b.getType()) && Values.POPULATOR_LIQUID_FLOW.getBoolean()) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent e) {
        if (Pregen.getCurrentPregen() != Pregen.DONE && !Values.POPULATOR_MOB_SPAWNING.getBoolean() && GenerationManager.getWorldsPregen().contains(e.getLocation().getWorld())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (Pregen.getCurrentPregen() != Pregen.DONE && !Values.POPULATOR_MOB_SPAWNING.getBoolean() && GenerationManager.getWorldsPregen().contains(e.getLocation().getWorld())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent e) {
        if (Pregen.getCurrentPregen() == Pregen.PROGRESS && GenerationManager.getWorldsPregen().contains(e.getLocation().getWorld())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onStart(GameStartEvent e) {
        if (e.isCancelled()) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
    }
}

